/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.serial.xml;

import org.catacomb.interlish.structure.Attribute;
import org.catacomb.serial.xml.NamedString;

public class XMLToken {
    static final int NONE = 0;
    static final int OPEN = 1;
    static final int CLOSE = 2;
    static final int NUMBER = 3;
    static final int STRING = 4;
    static final int OPENCLOSE = 5;
    static final int INTRO = 6;
    static final int COMMENT = 7;
    String[] types = new String[]{"NONE", "OPEN", "CLOSE", "NUMBER", "STRING", "OPENCLOSE", "INTRO", "COMMENT"};
    int type = 0;
    String svalue;
    double dvalue;
    int natt;
    String[] attNV;

    public boolean isOpen() {
        return this.type == 1 || this.type == 5;
    }

    public boolean isClose() {
        return this.type == 5 || this.type == 2;
    }

    public boolean isNumber() {
        return this.type == 3;
    }

    public boolean isString() {
        return this.type == 4;
    }

    public boolean isNone() {
        return this.type == 0;
    }

    public boolean isIntro() {
        return this.type == 6;
    }

    public boolean isComment() {
        return this.type == 7;
    }

    public String toString() {
        String s = String.valueOf(this.types[this.type]) + " ";
        if (this.type == 1 || this.type == 4 || this.type == 6 || this.type == 7 || this.type == 2 || this.type == 5) {
            s = String.valueOf(s) + this.svalue;
            if ((this.type == 1 || this.type == 5) && this.natt > 0) {
                int i = 0;
                while (i < this.natt) {
                    s = String.valueOf(s) + "\n    " + this.attNV[2 * i] + "=" + this.attNV[2 * i + 1];
                    ++i;
                }
            }
        } else if (this.type == 3) {
            s = String.valueOf(s) + " " + this.dvalue;
        }
        return s;
    }

    public void setType(int itype) {
        this.type = itype;
    }

    public void setStringValue(String s) {
        this.svalue = s;
    }

    public void setDValue(double d) {
        this.dvalue = d;
    }

    public void setAttributes(String[] sa) {
        this.attNV = sa;
        this.natt = sa.length / 2;
    }

    public boolean hasAttribute(String sat) {
        boolean bret = false;
        int i = 0;
        while (i < this.natt) {
            if (this.attNV[2 * i].equals(sat)) {
                bret = true;
            }
            ++i;
        }
        return bret;
    }

    public Attribute[] getAttributes() {
        Attribute[] nvpa = new NamedString[this.natt];
        int i = 0;
        while (i < this.natt) {
            nvpa[i] = new NamedString(this.attNV[2 * i], this.attNV[2 * i + 1]);
            ++i;
        }
        return nvpa;
    }

    public String getAttribute(String sat) {
        String sret = null;
        int i = 0;
        while (i < this.natt) {
            if (this.attNV[2 * i].equals(sat)) {
                sret = this.attNV[2 * i + 1];
            }
            ++i;
        }
        return sret;
    }

    public String getName() {
        return this.svalue;
    }

    public String getOpenTagString() {
        return "<" + this.svalue + ">";
    }

    public String getCloseTagString() {
        return "</" + this.svalue + ">";
    }

    public boolean closes(XMLToken start) {
        return this.svalue.equals(start.getName()) && this.isClose();
    }

    public int getNumAttributes() {
        return this.natt;
    }

    public String getAttributeName(int i) {
        return this.attNV[2 * i];
    }

    public String getAttributeValue(int i) {
        return this.attNV[2 * i + 1];
    }
}

