/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.serial.om;

import java.util.ArrayList;
import java.util.List;
import org.catacomb.interlish.structure.Attribute;
import org.catacomb.interlish.structure.Element;
import org.catacomb.serial.ElementSerializer;
import org.catacomb.serial.om.OmAttribute;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OmElement
implements Element {
    String name;
    String body;
    List<Attribute> attributes;
    List<Element> elements;
    private Attribute p_bufAtt;

    public OmElement() {
    }

    public OmElement(String s) {
        this.name = s;
    }

    public String toString() {
        String sret = "OmElemnt:" + this.name;
        if (this.attributes != null) {
            for (Attribute oma : this.attributes) {
                sret = String.valueOf(sret) + " " + oma.getName() + "=" + oma.getValue();
            }
        }
        int nel = this.elements != null ? this.elements.size() : 0;
        sret = String.valueOf(sret) + " [" + nel + " elements]";
        sret = String.valueOf(sret) + " body=" + this.body;
        return sret;
    }

    public void addToBody(String s) {
        this.body = this.body == null ? s : String.valueOf(this.body) + " " + s;
    }

    public OmElement(ArrayList<Attribute> ala, ArrayList<Element> ale) {
        this.name = null;
        this.attributes = ala;
        this.elements = ale;
        this.body = null;
    }

    public void setName(String s) {
        this.name = s;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setBody(String s) {
        this.body = s;
    }

    public String getBody() {
        return this.body;
    }

    public boolean hasBody() {
        return this.body != null;
    }

    @Override
    public boolean hasText() {
        return this.body != null;
    }

    @Override
    public String getText() {
        return this.body;
    }

    public void copyAttributes(Attribute[] atta) {
        if (atta != null) {
            int i = 0;
            while (i < atta.length) {
                Attribute att = atta[i];
                this.addAttribute(att.getName(), att.getValue());
                ++i;
            }
        }
    }

    @Override
    public Attribute[] getAttributeArray() {
        Attribute[] ret = null;
        if (this.attributes != null) {
            ret = new Attribute[this.attributes.size()];
            int na = 0;
            for (Attribute att : this.attributes) {
                ret[na++] = att;
            }
        }
        return ret;
    }

    @Override
    public boolean hasAttribute(String nm) {
        return this.getAttribute(nm) != null;
    }

    public void setAttribute(String nm, String val) {
        OmAttribute oma = this.getOmAttribute(nm);
        oma.setValue(val);
    }

    public OmAttribute getOmAttribute(String nm) {
        OmAttribute oma = null;
        if (this.attributes != null) {
            for (Attribute att : this.attributes) {
                if (!att.getName().equals(nm)) continue;
                oma = (OmAttribute)att;
                break;
            }
        }
        return oma;
    }

    @Override
    public String getAttribute(String nm) {
        String ret = null;
        if (this.p_bufAtt != null && this.p_bufAtt.getName().equals(nm)) {
            ret = this.p_bufAtt.getValue();
        } else {
            this.p_bufAtt = this.getOmAttribute(nm);
            if (this.p_bufAtt != null) {
                ret = this.p_bufAtt.getValue();
            }
        }
        return ret;
    }

    @Override
    public boolean hasAttributes() {
        return this.attributes != null && this.attributes.size() > 0;
    }

    @Override
    public boolean hasElements() {
        return this.elements != null && this.elements.size() > 0;
    }

    @Override
    public Element[] getElementArray() {
        Element[] ret = null;
        if (this.elements != null) {
            ret = new Element[this.elements.size()];
            int na = 0;
            for (Element elt : this.elements) {
                ret[na++] = elt;
            }
        }
        return ret;
    }

    @Override
    public Element getElement(String s) {
        Element ret = null;
        if (this.elements != null) {
            for (Element elt : this.elements) {
                if (!elt.getName().equals(s)) continue;
                ret = elt;
                break;
            }
        }
        return ret;
    }

    public void addElement(Element elt) {
        if (this.elements == null) {
            this.elements = new ArrayList<Element>();
        }
        this.elements.add(elt);
    }

    public void addAttribute(String n, String v) {
        OmAttribute att = new OmAttribute(n, v);
        this.addAttribute(att);
    }

    public void addAttribute(Attribute att) {
        if (this.attributes == null) {
            this.attributes = new ArrayList<Attribute>();
        }
        this.attributes.add(att);
    }

    public void setAttributes(ArrayList<Attribute> ala) {
        if (this.attributes != null && this.attributes.size() > 0) {
            System.out.println("sand.state.element error - overwriting non empty att array ");
            new Exception().printStackTrace();
        }
        this.attributes = ala;
    }

    public void setElements(ArrayList<Element> ale) {
        if (this.elements != null && this.elements.size() > 0) {
            System.out.println("sand.state.element error - overwriting non empty elt array ");
            new Exception().printStackTrace();
        }
        this.elements = ale;
    }

    @Override
    public List<Attribute> getAttributes() {
        return this.attributes;
    }

    @Override
    public List<Element> getElements() {
        return this.elements;
    }

    @Override
    public String serialize() {
        return ElementSerializer.serializeContent(this);
    }
}

