/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.serial.jar;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.catacomb.interlish.structure.Binariable;
import org.catacomb.report.E;
import org.catacomb.serial.Serializer;
import org.catacomb.serial.jar.CustomJar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomJarWriter {
    HashMap<String, Object> itemHM;

    public CustomJarWriter() {
        this.itemHM = new HashMap();
    }

    public CustomJarWriter(HashMap<String, Object> hm) {
        this.itemHM = hm;
    }

    public void addMain(String sdata) {
        this.add(CustomJar.getMetaMain(), "main");
        this.add("main", sdata);
    }

    public void addMain(File f) {
        this.add(CustomJar.getMetaMain(), f.getName());
        this.add(f);
    }

    public void addMimetype(String mt) {
        this.add(CustomJar.getMetaMime(), mt);
    }

    public void add(File f) {
        this.add(f.getName(), f);
    }

    public void add(String name, Object value) {
        this.itemHM.put(name, value);
    }

    public void write(File fout) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ZipOutputStream zos = new ZipOutputStream(baos);
            for (String name : this.itemHM.keySet()) {
                Object value = this.itemHM.get(name);
                zos.putNextEntry(new ZipEntry(name));
                if (value instanceof File) {
                    FileInputStream fis = new FileInputStream((File)value);
                    byte[] buf = new byte[4096];
                    int nread = 0;
                    while ((nread = fis.read(buf)) > 0) {
                        zos.write(buf, 0, nread);
                    }
                    fis.close();
                } else if (value instanceof Binariable) {
                    E.error("data jar binarizable object but code is missing ");
                } else {
                    String sdata = "";
                    sdata = value instanceof String ? (String)value : Serializer.serialize(value);
                    OutputStreamWriter osw = new OutputStreamWriter(zos);
                    BufferedWriter bw = new BufferedWriter(osw);
                    bw.write(sdata, 0, sdata.length());
                    bw.flush();
                }
                zos.closeEntry();
            }
            zos.flush();
            zos.close();
            byte[] ba = baos.toByteArray();
            this.writeByteArrayToFile(ba, fout);
        }
        catch (Exception ex) {
            E.error("custom jar writing error " + ex);
            ex.printStackTrace();
        }
    }

    private void writeByteArrayToFile(byte[] ba, File fout) throws IOException {
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(fout));
        ((OutputStream)os).write(ba);
        ((OutputStream)os).flush();
        ((OutputStream)os).close();
    }
}

