/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.numeric.math;

public final class NetMath {
    public static double[] makeSampledBiExponential(double tr, double tf, double dt) {
        double eps = 1.0E-6;
        if (tr < eps) {
            tr = eps;
        }
        if (tf < tr + eps) {
            tf = tr + eps;
        }
        double tmax = Math.log(tf / tr) / (1.0 / tr - 1.0 / tf);
        return NetMath.makeSampledBiExponential(tr, tf, 3.0 * tmax, dt);
    }

    public static double[] makeSampledBiExponential(double tr, double tf, double ttot, double dt) {
        double eps = 1.0E-6;
        if (tr < eps) {
            tr = eps;
        }
        if (tf < tr + eps) {
            tf = tr + eps;
        }
        double tmax = Math.log(tf / tr) / (1.0 / tr - 1.0 / tf);
        double afac = 1.0 / (Math.exp(-tmax / tf) - Math.exp(-tmax / tr));
        int np = (int)(ttot / dt);
        double[] dd = new double[np];
        int i = 0;
        while (i < np) {
            double t = (double)i * dt;
            dd[i] = afac * (Math.exp(-t / tf) - Math.exp(-t / tr));
            ++i;
        }
        return dd;
    }

    public static double[] vectorScale(int[] ii, double f) {
        int n = ii.length;
        double[] dd = new double[n];
        int i = 0;
        while (i < n) {
            dd[i] = f * (double)ii[i];
            ++i;
        }
        return dd;
    }

    private static double[] colorScale(int[] ii) {
        int n = ii.length;
        double[] dd = new double[n];
        double f = 0.0013020833333333333;
        int i = 0;
        while (i < n) {
            int c = ii[i];
            dd[i] = f * (double)(c % 256 + c / 256 % 256 + c / 65536 % 256);
            ++i;
        }
        return dd;
    }
}

