/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.numeric.difnet.model;

import org.catacomb.numeric.difnet.DiffusibleQuantity;
import org.catacomb.numeric.difnet.StateNode;
import org.catacomb.numeric.difnet.Stimulus;
import org.catacomb.numeric.difnet.StructureNode;
import org.catacomb.numeric.difnet.model.BasicStructureNode;

public class BasicStateNode
implements StateNode {
    BasicStructureNode structure;
    double value;
    double current;
    double capacitance;
    Stimulus stimulus;
    double appliedValue;

    public BasicStateNode(BasicStructureNode bsn) {
        this.structure = bsn;
        this.value = this.structure.getInitialValue();
        this.capacitance = this.structure.getCapacitance();
        this.appliedValue = this.structure.fixed ? this.structure.getInitialValue() : -999.0;
    }

    public double getValue(DiffusibleQuantity dq) {
        return this.value;
    }

    public double getAppliedValue(DiffusibleQuantity dq) {
        return this.appliedValue;
    }

    public void setValue(DiffusibleQuantity dq, double d) {
        this.value = d;
    }

    public void setFlux(DiffusibleQuantity dq, double d) {
        this.current = d;
    }

    public void setStimulus(Stimulus stim) {
        this.stimulus = stim;
    }

    public Stimulus getStimulus() {
        return this.stimulus;
    }

    public double getCapacitance(DiffusibleQuantity dq) {
        return this.capacitance;
    }

    public StructureNode getStructureNode() {
        return this.structure;
    }
}

