/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.numeric.data;

import java.util.ArrayList;
import org.catacomb.numeric.data.FloatRow;
import org.catacomb.numeric.data.FloatVector;

public class VectorSet {
    String[] names;
    int nvec;
    int npoint;
    ArrayList<FloatRow> rows = new ArrayList();
    double[][] adat;

    public void setNames(String s) {
        this.names = s.split("[, \n\r\t]+");
        this.nvec = this.names.length;
    }

    public void addRow(FloatRow fr) {
        this.rows.add(fr);
    }

    private void digestRows() {
        this.npoint = this.rows.size();
        this.adat = new double[this.nvec][this.npoint];
        int ir = 0;
        for (FloatRow fr : this.rows) {
            double[] rd = fr.getValue();
            int k = 0;
            while (k < this.nvec && k < rd.length) {
                this.adat[k][ir] = rd[k];
                ++k;
            }
            ++ir;
        }
    }

    public FloatVector[] getVectors() {
        this.digestRows();
        FloatVector[] fva = new FloatVector[this.nvec];
        int i = 0;
        while (i < this.nvec) {
            fva[i] = new FloatVector(this.names[i], this.adat[i]);
            ++i;
        }
        return fva;
    }
}

