/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.numeric.data;

import java.util.ArrayList;
import org.catacomb.report.E;

public class DataTable {
    int ncol;
    String[] headings;
    ArrayList<double[]> rows = new ArrayList();
    int nrow;
    double[][] columns;

    public void setNColumn(int n) {
        this.ncol = n;
    }

    public void setHeadings(String[] sa) {
        if (this.headings != null) {
            E.warning("overwriting headings? " + this.headings[0] + " with " + sa[0]);
        }
        this.headings = sa;
    }

    public String[] getHeadings() {
        if (this.headings == null) {
            this.headings = new String[this.ncol];
        }
        int i = 0;
        while (i < this.ncol) {
            this.headings[i] = "C" + i;
            ++i;
        }
        return this.headings;
    }

    public void addRow(double[] da) {
        this.rows.add(da);
    }

    public void close() {
        this.nrow = this.rows.size();
        this.columns = new double[this.ncol][this.nrow];
        int i = 0;
        while (i < this.nrow) {
            double[] row = this.rows.get(i);
            int j = 0;
            while (j < this.ncol) {
                this.columns[j][i] = row[j];
                ++j;
            }
            ++i;
        }
    }

    public double[] getColumn(int icol) {
        if (this.columns == null) {
            this.close();
        }
        return this.columns[icol];
    }

    public int getNColumn() {
        return this.ncol;
    }

    public double[][] getRows() {
        if (this.columns == null) {
            this.close();
        }
        double[][] ret = new double[this.nrow][this.ncol];
        int i = 0;
        while (i < this.nrow) {
            int j = 0;
            while (j < this.ncol) {
                ret[i][j] = this.columns[j][i];
                ++j;
            }
            ++i;
        }
        return ret;
    }

    public double[][] getColumns() {
        if (this.columns == null) {
            this.close();
        }
        return this.columns;
    }
}

