/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.numeric.data;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.StringTokenizer;
import org.catacomb.numeric.data.DataTable;
import org.catacomb.report.E;

public class AsciiIO {
    public static DataTable readTable(File f) {
        DataTable ret = new DataTable();
        int ncol = 0;
        if (f.exists()) {
            try {
                BufferedReader br = new BufferedReader(new FileReader(f));
                while (br.ready()) {
                    double[] da;
                    String line = br.readLine();
                    if (line.trim().length() <= 0) continue;
                    StringTokenizer st = new StringTokenizer(line, " ,;\t");
                    if (ncol == 0) {
                        ncol = st.countTokens();
                        ret.setNColumn(ncol);
                    }
                    if (st.countTokens() < ncol) {
                        E.warning("too few elements in row - skipping " + line);
                        continue;
                    }
                    if (st.countTokens() > ncol) {
                        E.warning("extra tokens in line beyond " + ncol + "? " + line);
                    }
                    if ((da = AsciiIO.readRow(st, ncol)) == null) {
                        st = new StringTokenizer(line, " ,;\t");
                        ret.setHeadings(AsciiIO.readStringRow(st, ncol));
                        continue;
                    }
                    ret.addRow(da);
                }
            }
            catch (Exception ex) {
                E.warning("file read exception for " + f + " " + ex);
                ex.printStackTrace();
            }
        } else {
            E.warning("no such file " + f);
        }
        ret.close();
        return ret;
    }

    public static double[] readRow(StringTokenizer st, int ncol) {
        double[] ret = new double[ncol];
        try {
            int i = 0;
            while (i < ret.length) {
                ret[i] = Double.parseDouble(st.nextToken());
                ++i;
            }
        }
        catch (Exception ex) {
            ret = null;
        }
        return ret;
    }

    public static String[] readStringRow(StringTokenizer st, int ncol) {
        String[] ret = new String[ncol];
        if (st.countTokens() < ncol) {
            E.error("need " + ncol + " but got only " + st.countTokens() + " tokens in " + st);
        } else {
            int i = 0;
            while (i < ncol) {
                ret[i] = st.nextToken();
                ++i;
            }
        }
        return ret;
    }

    public static double[] readRow(String line) {
        StringTokenizer st = new StringTokenizer(line, " ,;\t[]");
        int nc = st.countTokens();
        return AsciiIO.readRow(st, nc);
    }
}

