/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.movie.gif;

import org.catacomb.report.E;

public final class ByteAccumulator {
    int iin;
    byte[] ba;
    int ipend;
    int npend;
    int inxb;
    int iout;
    static int[] msk;

    static {
        int[] nArray = new int[10];
        nArray[1] = 1;
        nArray[2] = 3;
        nArray[3] = 7;
        nArray[4] = 15;
        nArray[5] = 31;
        nArray[6] = 63;
        nArray[7] = 127;
        nArray[8] = 255;
        nArray[9] = 511;
        msk = nArray;
    }

    public ByteAccumulator(int n) {
        this.ba = new byte[n];
        this.iin = 0;
    }

    public ByteAccumulator(byte[] ba) {
        this.ba = ba;
        this.iout = 0;
        this.inxb = 0;
    }

    public int getNextWritePosition() {
        return this.iin;
    }

    public void checkDoubleSpace() {
        if (this.iin > this.ba.length / 2) {
            int n = this.ba.length;
            byte[] bb = new byte[2 * n];
            int i = 0;
            while (i < n) {
                bb[i] = this.ba[i];
                ++i;
            }
            this.ba = bb;
        }
    }

    public void trim() {
        byte[] ret = new byte[this.iin];
        System.arraycopy(this.ba, 0, ret, 0, ret.length);
        this.ba = ret;
    }

    public byte[] getData() {
        this.flush();
        this.trim();
        return this.ba;
    }

    public void setByte(int i, byte b) {
        this.ba[i] = b;
    }

    public void setByte(int i, int b) {
        this.ba[i] = (byte)b;
    }

    public void appendByte(byte b) {
        this.ba[this.iin++] = b;
    }

    public void appendByte(int i) {
        this.ba[this.iin++] = (byte)i;
    }

    public void appendBytes(byte[] b) {
        System.arraycopy(b, 0, this.ba, this.iin, b.length);
        this.iin += b.length;
    }

    public void appendBytes(byte[] b, int ioff, int nb) {
        System.arraycopy(b, ioff, this.ba, this.iin, nb);
        this.iin += nb;
    }

    public void appendString(String s) {
        this.appendBytes(s.getBytes());
    }

    public void appendInt2(int i) {
        byte[] bt = new byte[]{(byte)(i & 0xFF), (byte)(i >> 8 & 0xFF)};
        this.appendBytes(bt);
    }

    public void appendInt4(int i) {
        byte[] bt = new byte[]{(byte)(i >> 24 & 0xFF), (byte)(i >> 16 & 0xFF), (byte)(i >> 8 & 0xFF), (byte)(i & 0xFF)};
        this.appendBytes(bt);
    }

    public void append(int i, int p) {
        if (i < 0) {
            E.error("appending negeative no to byte stream");
        }
        this.ipend += i << this.npend;
        this.npend += p;
        while (this.npend >= 8) {
            this.appendByte(this.ipend & 0xFF);
            this.ipend >>= 8;
            this.npend -= 8;
        }
    }

    public void flush() {
        if (this.npend > 0) {
            this.appendByte(this.ipend & 0xFF);
        }
    }

    public int nextElt(int p) {
        int ng = 0;
        int ir = 0;
        while (ng < p) {
            if (this.iout >= this.ba.length) {
                return -1;
            }
            int ntk = p - ng;
            if (ntk > 8 - this.inxb) {
                ntk = 8 - this.inxb;
            }
            ir += (this.ba[this.iout] >> this.inxb & msk[ntk]) << ng;
            this.inxb += ntk;
            if (this.inxb == 8) {
                ++this.iout;
                this.inxb = 0;
            }
            ng += ntk;
        }
        return ir;
    }
}

