/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.interlish.version;

import org.catacomb.about.AboutBase;
import org.catacomb.interlish.util.JUtil;
import org.catacomb.report.E;

public class BuildInfo {
    public String name;
    public String num;
    public String time;
    public String date;

    public static BuildInfo getInfo() {
        return new BuildInfo();
    }

    public BuildInfo() {
        String s = JUtil.getRelativeResource(new AboutBase(), "version.xml");
        this.time = "unknown";
        this.date = "unknown";
        this.name = "unknown";
        this.num = "0";
        if (s != null && s.length() > 0) {
            this.time = this.getQuotedText(s, "time=");
            this.date = this.getQuotedText(s, "date=");
            this.num = this.getQuotedText(s, "num=");
            this.name = this.getQuotedText(s, "name=");
        }
    }

    private String getQuotedText(String src, String start) {
        String ret = "";
        if (src.indexOf(start) >= 0) {
            String rest = src.substring(src.indexOf(start) + start.length() + 1, src.length());
            if (rest.indexOf("\"") > 0) {
                ret = rest.substring(0, rest.indexOf("\""));
            } else {
                E.warning("no closing quote? - seeking " + start + " in " + src);
            }
        } else {
            E.warning("cant find " + start + " in " + src);
        }
        return ret;
    }

    public void printIntro() {
        System.out.println(this.getIntro());
    }

    public String getIntro() {
        return String.valueOf(this.name) + " " + this.num + "   [" + this.date + ", " + this.time + "]";
    }

    public String getFrameTitle() {
        return this.getIntro();
    }
}

