/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.interlish.util;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import org.catacomb.Root;
import org.catacomb.interlish.report.Logger;
import org.catacomb.interlish.report.PrintLogger;
import org.catacomb.report.E;

public class JUtil {
    static Class rootClass = new Root().getClass();
    static String fileSep = "/";
    static String rootPath = "org" + fileSep + "catacomb";

    public static String getRelativeResource(Object obj, String path) {
        return JUtil.getRelativeResource(null, obj.getClass(), path);
    }

    public static String getRelativeResource(String s) {
        return JUtil.getRelativeResource(null, rootClass, s);
    }

    public static String getRelativeResource(Logger logger, Class cls, String path) {
        String sret = null;
        if (logger == null) {
            logger = new PrintLogger();
        }
        try {
            InputStream fis = cls.getResourceAsStream(path);
            sret = JUtil.readInputStream(logger, fis);
        }
        catch (Exception ex) {
            logger.log("ResourceAccess - cant get " + path + " " + ex);
            ex.printStackTrace();
        }
        return sret;
    }

    public static String getXMLResource(String path) {
        String sp = null;
        if (path.endsWith(".xml") || path.indexOf(".") < 0) {
            E.warning("getXMLReousrce should have a dot path, not " + path);
            sp = path;
        } else {
            sp = String.valueOf(path.replaceAll("\\.", fileSep)) + ".xml";
        }
        return JUtil.getResource(sp);
    }

    public static String getFileResource(String path, String fnm) {
        String sp = String.valueOf(path.replaceAll("\\.", fileSep)) + fileSep + fnm;
        return JUtil.getResource(sp);
    }

    private static String getResource(String path) {
        String sret = null;
        PrintLogger logger = new PrintLogger();
        try {
            if (path.startsWith(rootPath)) {
                path = path.substring(rootPath.length() + 1, path.length());
                InputStream fis = rootClass.getResourceAsStream(path);
                sret = JUtil.readInputStream(logger, fis);
            } else {
                E.warning("reading foreign resource from class path?");
                InputStream fis = ClassLoader.getSystemResourceAsStream(path);
                sret = JUtil.readInputStream(logger, fis);
            }
        }
        catch (Exception ex) {
            E.error("ResourceAccess - cant get " + path + " " + ex);
            ex.printStackTrace();
        }
        return sret;
    }

    private static String readInputStream(Logger logger, InputStream fis) throws NullPointerException, IOException {
        String sret = null;
        InputStreamReader insr = new InputStreamReader(fis);
        BufferedReader fr = new BufferedReader(insr);
        StringBuffer sb = new StringBuffer();
        while (fr.ready()) {
            sb.append(fr.readLine());
            sb.append("\n");
        }
        fr.close();
        sret = sb.toString();
        return sret;
    }

    public static void copyBinaryResource(Logger logger, String respath, File dest) {
        if (dest.exists()) {
            return;
        }
        if (logger == null) {
            logger = new PrintLogger();
        }
        try {
            int len;
            if (respath.startsWith(rootPath)) {
                respath = respath.substring(rootPath.length() + 1, respath.length());
            }
            InputStream in = rootClass.getResourceAsStream(respath);
            FileOutputStream out = new FileOutputStream(dest);
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            in.close();
            ((OutputStream)out).close();
        }
        catch (Exception ex) {
            E.warning("ResourceAccess - cant get " + respath + " " + ex);
            ex.printStackTrace();
        }
    }

    public static void extractResources(Logger logger, String path, File dest) {
        path = path.replaceAll("\\.", fileSep);
        String sl = JUtil.getFileResource(path, "_files.txt");
        StringTokenizer st = new StringTokenizer(sl, " \n\r\t");
        while (st.hasMoreTokens()) {
            String tok = st.nextToken().trim();
            if (tok.length() <= 0) continue;
            String respath = String.valueOf(path) + "/" + tok;
            File destfile = new File(dest, tok);
            JUtil.copyBinaryResource(logger, respath, destfile);
        }
        String sld = JUtil.getFileResource(path, "_directories.txt");
        StringTokenizer std = new StringTokenizer(sld, " \n\r\t");
        while (std.hasMoreTokens()) {
            String tok = std.nextToken().trim();
            if (tok.length() <= 0) continue;
            File fsub = new File(dest, tok);
            fsub.mkdir();
            JUtil.extractResources(logger, String.valueOf(path) + fileSep + tok, fsub);
        }
    }

    public static Object newInstance(String s) {
        Object ret = null;
        if (!s.startsWith("org.catacomb")) {
            s = "org.catacomb." + s;
        }
        try {
            Class<?> c = Class.forName(s);
            ret = c.newInstance();
        }
        catch (Exception ex) {
            E.error("cant instantiate " + s + " " + ex);
            ex.printStackTrace();
        }
        return ret;
    }

    public static String shortClassName(Object ov) {
        String cnm = ov.getClass().getName();
        cnm = cnm.substring(cnm.lastIndexOf(".") + 1, cnm.length());
        return cnm;
    }

    public static void extractMissingResources(String path, File dir) {
        JUtil.extractResources(new PrintLogger(), path, dir);
    }

    public static void unpackJar(File fjar, File fout) {
        try {
            JarFile jf = new JarFile(fjar);
            Enumeration<JarEntry> en = jf.entries();
            while (en.hasMoreElements()) {
                JarEntry je = en.nextElement();
                File f = new File(fout, je.getName());
                if (je.isDirectory()) {
                    f.mkdirs();
                    continue;
                }
                if (f.getPath().indexOf("META-INF") >= 0) continue;
                f.getParentFile().mkdirs();
                InputStream is = jf.getInputStream(je);
                FileOutputStream fos = new FileOutputStream(f);
                while (is.available() > 0) {
                    fos.write(is.read());
                }
                fos.close();
                is.close();
            }
        }
        catch (Exception ex) {
            E.error("cant unpack " + fjar + " : " + ex);
        }
    }

    public static void extractJarResources(Object base, String jarName, File destDirectory) {
        try {
            InputStream ins = base.getClass().getResourceAsStream(jarName);
            JarInputStream jins = new JarInputStream(ins);
            while (jins.available() > 0) {
                JarEntry je = jins.getNextJarEntry();
                if (je == null) continue;
                File f = new File(destDirectory, je.getName());
                if (je.isDirectory()) {
                    f.mkdirs();
                    continue;
                }
                if (f.getPath().indexOf("META-INF") >= 0) continue;
                f.getParentFile().mkdirs();
                int nb = (int)je.getSize();
                byte[] ba = new byte[nb];
                int nread = 0;
                while (nread < nb) {
                    nread += jins.read(ba, nread, nb - nread);
                }
                BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(f));
                ((OutputStream)os).write(ba);
                ((OutputStream)os).flush();
            }
        }
        catch (Exception ex) {
            E.error("cant extract resources - " + ex);
            ex.printStackTrace();
        }
    }
}

