/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.interlish.content;

import java.util.ArrayList;
import org.catacomb.interlish.content.NVPair;
import org.catacomb.interlish.content.PrimitiveValue;
import org.catacomb.interlish.structure.StructureWatcher;
import org.catacomb.report.E;

public class QuantifiedListValue
extends PrimitiveValue {
    private NVPair[] items;
    private ArrayList<StructureWatcher> p_structureWatchers;

    public QuantifiedListValue() {
        this.items = new NVPair[0];
    }

    public QuantifiedListValue(NVPair[] aa) {
        this.items = aa;
    }

    public String toString() {
        return "QuantifiedListValue: " + this.items.length + " items ";
    }

    public void silentSetQuantity(String s, double d) {
        if (s == null) {
            return;
        }
        boolean done = false;
        NVPair[] nVPairArray = this.items;
        int n = 0;
        int n2 = nVPairArray.length;
        while (n < n2) {
            NVPair nvp = nVPairArray[n];
            if (nvp.isCalled(s)) {
                nvp.setValue(d, this.sDouble(d));
                done = true;
                break;
            }
            ++n;
        }
        if (!done) {
            NVPair[] newitems = new NVPair[this.items.length + 1];
            int i = 0;
            while (i < this.items.length) {
                newitems[i] = this.items[i];
                ++i;
            }
            this.items = newitems;
            this.items[this.items.length - 1] = new NVPair(s, d, this.sDouble(d));
            this.reportStructureChange("added");
        }
        this.logChange();
    }

    public int indexOf(String s) {
        int ipos = -1;
        int iit = 0;
        while (iit < this.items.length) {
            if (this.items[iit].isCalled(s)) {
                ipos = iit;
                break;
            }
            ++iit;
        }
        return ipos;
    }

    public void removeItem(String s) {
        int ipos = this.indexOf(s);
        if (ipos >= 0) {
            this.removeItem(ipos);
        }
    }

    private void removeItem(int itg) {
        NVPair[] newitems = new NVPair[this.items.length - 1];
        int i = 0;
        while (i < itg) {
            newitems[i] = this.items[i];
            ++i;
        }
        i = itg;
        while (i < this.items.length - 1) {
            newitems[i] = this.items[i + 1];
            ++i;
        }
        this.items = newitems;
        this.reportStructureChange("removed");
    }

    public void reportableSetQuantity(String s, double d, Object src) {
        this.silentSetQuantity(s, d);
        this.reportValueChange(src);
    }

    public int size() {
        return this.items.length;
    }

    private String sDouble(double d) {
        return String.format("%.3g", new Double(d));
    }

    public String[] getItemNames() {
        String[] sa = new String[this.items.length];
        int i = 0;
        while (i < this.items.length) {
            sa[i] = this.items[i].getName();
            ++i;
        }
        return sa;
    }

    public NVPair[] getItems() {
        return this.items;
    }

    public NVPair[] getNameValueItems() {
        return this.items;
    }

    public double getIthDouble(int idx) {
        return this.items[idx].getValue();
    }

    public void setIthDouble(int idx, double dv) {
        this.items[idx].setValue(dv, this.sDouble(dv));
        E.info("qlv reporting set val " + dv);
        this.reportValueChange(this);
    }

    public void addStructureWatcher(StructureWatcher sw) {
        if (this.p_structureWatchers == null) {
            this.p_structureWatchers = new ArrayList();
        }
        this.p_structureWatchers.add(sw);
    }

    public void removeStructureWatcher(StructureWatcher sw) {
        this.p_structureWatchers.remove(sw);
    }

    public void reportStructureChange(String typ) {
        if (this.p_structureWatchers != null) {
            for (StructureWatcher sw : this.p_structureWatchers) {
                sw.structureChanged(this, typ);
            }
        }
    }
}

