/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.interlish.content;

import java.awt.Color;

public class ColorTable {
    String name;
    int nColor;
    Color[] colors;
    double rangeMin;
    double rangeMax;
    double rangeDelta;

    public ColorTable(String snm) {
        this.name = snm;
        this.nColor = 100;
        this.colors = new Color[this.nColor];
        Color c = Color.gray;
        int i = 0;
        while (i < this.nColor) {
            this.colors[i] = c;
            ++i;
        }
        this.rangeMin = 0.0;
        this.rangeMax = 1.0;
        this.rangeDelta = 1.0;
    }

    public static ColorTable makeDefaultColorTable() {
        return new ColorTable("default");
    }

    public String toString() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public int getNColor() {
        return this.nColor;
    }

    public Color getColor(int i) {
        return this.colors[i];
    }

    public void setNColor(int nc) {
        Color[] ac = new Color[nc];
        int i = 0;
        while (i < nc) {
            ac[i] = this.interpColorAt(1.0 * (double)i / ((double)nc - 1.0));
            ++i;
        }
        this.colors = ac;
        this.nColor = nc;
    }

    public void setColor(int ic, Color c) {
        this.colors[ic] = c;
    }

    public Color[] getColors() {
        return this.colors;
    }

    public Color getColor(double f) {
        return this.getFractionalColor((f - this.rangeMin) / this.rangeDelta);
    }

    public Color getFractionalColor(double f) {
        double fr = f * (double)this.nColor;
        int ic = (int)(fr + 0.5);
        if (ic < 0) {
            ic = 0;
        }
        if (ic >= this.nColor) {
            ic = this.nColor - 1;
        }
        return this.colors[ic];
    }

    public Color interpColorAt(double frac) {
        if (frac < 0.0) {
            frac = 0.0;
        }
        if (frac > 1.0) {
            frac = 1.0;
        }
        double fr = frac * (double)(this.nColor - 1);
        int ipr = (int)fr;
        double f = fr - (double)ipr;
        int inx = ipr + 1;
        if (inx >= this.nColor) {
            inx = this.nColor - 1;
        }
        Color ca = this.colors[ipr];
        Color cb = this.colors[inx];
        int car = ca.getRed();
        int cag = ca.getGreen();
        int cab = ca.getBlue();
        int dr = cb.getRed() - car;
        int dg = cb.getGreen() - cag;
        int db = cb.getBlue() - cab;
        Color ret = new Color((int)((double)car + f * (double)dr), (int)((double)cag + f * (double)dg), (int)((double)cab + f * (double)db));
        return ret;
    }

    public void interp(int a, int b) {
        Color ca = this.getColor(a);
        Color cb = this.getColor(b);
        int car = ca.getRed();
        int cag = ca.getGreen();
        int cab = ca.getBlue();
        int dr = cb.getRed() - car;
        int dg = cb.getGreen() - cag;
        int db = cb.getBlue() - cab;
        int i = a;
        while (i <= b) {
            double f = (double)(i - a) / (1.0 * (double)(b - a));
            this.setColor(i, new Color((int)((double)car + f * (double)dr), (int)((double)cag + f * (double)dg), (int)((double)cab + f * (double)db)));
            ++i;
        }
    }

    public void setRange(double dmin, double dmax) {
        this.rangeMin = dmin;
        this.rangeMax = dmax;
        this.syncRangeDelta();
    }

    private void syncRangeDelta() {
        this.rangeDelta = this.rangeMax - this.rangeMin;
        if (this.rangeDelta == 0.0) {
            this.rangeDelta = 1.0;
        }
    }

    public void setRangeMin(double d) {
        this.rangeMin = d;
        this.syncRangeDelta();
    }

    public void setRangeMax(double d) {
        this.rangeMax = d;
        this.syncRangeDelta();
    }

    public double getRangeMin() {
        return this.rangeMin;
    }

    public double getRangeMax() {
        return this.rangeMax;
    }
}

