/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.interlish.content;

import org.catacomb.interlish.content.PrimitiveValue;

public class BooleanValue
extends PrimitiveValue {
    private boolean boolval;
    private BooleanValue peer;

    public BooleanValue() {
        this.boolval = false;
    }

    public BooleanValue(boolean b) {
        this.boolval = b;
    }

    public String toString() {
        return this.boolval ? "true" : "false";
    }

    public void silentSetBoolean(boolean b) {
        this.boolval = b;
        this.logChange();
        if (this.peer != null) {
            this.peer.silentSetBoolean(b);
        }
    }

    public boolean getBoolean() {
        boolean ret = this.boolval;
        if (this.peer != null) {
            ret = this.peer.getBoolean();
        }
        return ret;
    }

    public boolean is() {
        return this.getBoolean();
    }

    public void reportableSetBoolean(boolean b, Object src) {
        this.silentSetBoolean(b);
        this.reportValueChange(src);
        if (this.peer != null) {
            this.peer.reportableSetBoolean(b, src);
        }
    }

    public void setPeer(BooleanValue dv) {
        this.peer = dv;
    }

    public void releasePeer() {
        this.peer = null;
    }

    public void copyFrom(BooleanValue src) {
        this.boolval = src.boolval;
    }
}

