/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.graph.gui;

import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import org.catacomb.graph.gui.BaseCanvas;
import org.catacomb.graph.gui.RangeListener;
import org.catacomb.report.E;

public class XAxisCanvas
extends BaseCanvas
implements RangeListener {
    static final long serialVersionUID = 1001L;
    double xlow;
    double xhigh;
    String labX;
    static final int[] intervals = new int[]{1, 2, 5};
    int ntick = 5;

    public XAxisCanvas(int w, int h) {
        super(w, h);
    }

    public void setLabel(String s) {
        this.labX = s;
    }

    public void rangeChanged(int mode, double[] xyxylims) {
        if (mode == 1 || mode == 3) {
            this.xlow = xyxylims[0];
            this.xhigh = xyxylims[2];
            this.repaint();
        }
    }

    public void paint2D(Graphics2D g) {
        this.drawAxis(g);
    }

    public final void drawAxis(Graphics g) {
        g.setColor(this.getNormalForeground());
        int width = this.getWidth();
        int height = this.getHeight();
        double xran = Math.abs(this.xhigh - this.xlow);
        double dx = 1.5 * xran / (double)this.ntick;
        double log = Math.log(dx) / Math.log(10.0);
        double powten = (int)Math.floor(log);
        int iiind = (int)(2.999 * (log - powten));
        if (iiind < 0 || iiind >= 3) {
            E.error("error gdc, 650: " + log + " " + powten + " " + iiind);
            iiind = 2;
        }
        int ii = intervals[iiind];
        dx = Math.pow(10.0, powten) * (double)ii;
        int i0 = (int)(this.xlow / dx);
        int i1 = (int)(this.xhigh / dx);
        int i = i0;
        while (i <= i1) {
            double xx = (double)i * dx;
            String lab = "0";
            if (i != 0) {
                lab = dx >= 0.999 && dx < 10000.0 ? String.valueOf((int)xx) : String.valueOf((float)xx);
            }
            int off = lab.length();
            off = 1 - 4 * off;
            if ((double)i * dx < 0.0) {
                off -= 4;
            }
            int ix = (int)((double)width * (xx - this.xlow) / (this.xhigh - this.xlow));
            g.drawString(lab, ix + off, 20);
            g.drawLine(ix, 0, ix, 5);
            if (this.labX != null) {
                FontMetrics fm = g.getFontMetrics();
                int ilx = width / 2 - fm.stringWidth(this.labX) / 2;
                int ily = height - 3;
                g.drawString(this.labX, ilx, ily);
            }
            ++i;
        }
    }
}

