/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.graph.gui;

import java.awt.Color;
import org.catacomb.graph.gui.Painter;
import org.catacomb.report.E;
import org.catacomb.util.ColorUtil;
import org.catacomb.util.Formatter;

public class GridPainter {
    static final int[] intervals = new int[]{1, 2, 5};
    Color gridColor;
    private boolean axesOnGrid = false;
    String xlabel = null;

    public void setGridBackground(Color c) {
        int ic = c.getRed() + c.getGreen() + c.getBlue();
        this.gridColor = ic > 380 ? ColorUtil.verySlightlyDarker(c) : ColorUtil.verySlightlyBrighter(c);
    }

    public void paint(Painter p) {
        double[] xyxy = p.getXYXYLimits();
        if (this.gridColor == null) {
            this.setGridBackground(Color.black);
        }
        int width = p.getCanvasWidth();
        int height = p.getCanvasHeight();
        double dx = xyxy[2] - xyxy[0];
        double dy = xyxy[3] - xyxy[1];
        double[] xpts = GridPainter.getTickValues(6, xyxy[0], xyxy[2]);
        int[] ixpts = GridPainter.getTicks(xpts, xyxy[0], xyxy[2], width);
        double[] ypts = GridPainter.getTickValues(6, xyxy[1], xyxy[3]);
        int[] iypts = GridPainter.getTicks(ypts, xyxy[1], xyxy[3], height);
        p.setColor(this.gridColor);
        int i = 0;
        while (i < ixpts.length) {
            p.drawPixelLine(ixpts[i], 0, ixpts[i], height);
            ++i;
        }
        i = 0;
        while (i < iypts.length) {
            p.drawPixelLine(0, height - iypts[i], width, height - iypts[i]);
            ++i;
        }
        if (this.axesOnGrid) {
            p.setColor(this.gridColor.darker());
            i = 0;
            while (i < ixpts.length) {
                p.drawCenteredString(Formatter.format(xpts[i], dx), ixpts[i], height - 10);
                ++i;
            }
            i = 0;
            while (i < iypts.length) {
                p.drawString(Formatter.format(ypts[i], dy), 10, height - iypts[i] + 4);
                ++i;
            }
            if (this.xlabel != null) {
                p.drawString(this.xlabel, width / 2, height - 2);
            }
        }
    }

    public static final double[] getTickValues(int ntick, double vlow, double vhigh) {
        double powten;
        double dv = 1.5 * Math.abs(vhigh - vlow) / (double)ntick;
        double log = Math.log(dv) / Math.log(10.0);
        int iiind = (int)(2.999 * (log - (powten = (double)((int)Math.floor(log)))));
        if (iiind < 0 || iiind >= 3) {
            E.error(" gdc, 650: " + log + " " + powten + " " + iiind);
            iiind = 2;
        }
        int ii = intervals[iiind];
        dv = Math.pow(10.0, powten) * (double)ii;
        int i0 = (int)(vlow / dv);
        int i1 = (int)(vhigh / dv);
        int nl = i1 - i0 + 1;
        double[] ret = new double[nl];
        int i = 0;
        while (i < nl) {
            ret[i] = (double)(i0 + i) * dv;
            ++i;
        }
        return ret;
    }

    public static final int[] getTicks(double[] va, double vlow, double vhigh, int range) {
        int nl = va.length;
        int[] ret = new int[nl];
        int i = 0;
        while (i < nl) {
            ret[i] = (int)((double)range * (va[i] - vlow) / (vhigh - vlow));
            ++i;
        }
        return ret;
    }

    public void setOnGridAxes() {
        this.axesOnGrid = true;
    }

    public void setXAxisLabel(String s) {
        this.xlabel = s;
    }
}

