/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.graph.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.catacomb.be.Position;
import org.catacomb.graph.gui.WorldCanvas;
import org.catacomb.interlish.structure.ContextMenu;
import org.catacomb.interlish.structure.SelectionActor;
import org.catacomb.report.E;

public class GraphContextMenu
implements ContextMenu {
    WorldCanvas canvas;
    JPopupMenu pMenu;
    SelectionActor handler;
    int nel = 0;

    public GraphContextMenu(WorldCanvas wc) {
        this.canvas = wc;
        this.pMenu = new JPopupMenu();
    }

    public void itemSelected(String s) {
        if (this.handler == null) {
            E.warning("no handler for event " + s);
        } else {
            this.handler.selectionAction(this, s);
        }
    }

    public void setContext(String[] options, SelectionActor h) {
        this.pMenu.removeAll();
        this.nel = 0;
        this.handler = h;
        String[] stringArray = options;
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String s = stringArray[n];
            if (s.equals("---")) {
                this.pMenu.addSeparator();
            } else {
                JMenuItem jmi = new JMenuItem(s);
                jmi.addActionListener(new GCMHandler(this, s));
                this.pMenu.add(jmi);
                ++this.nel;
            }
            ++n;
        }
    }

    public void showAt(Position pos) {
        if (this.nel > 0) {
            int[] ixy = this.canvas.getIntPosition(pos);
            this.pMenu.show(this.canvas, ixy[0], ixy[1]);
        }
    }

    class GCMHandler
    implements ActionListener {
        GraphContextMenu gcm;
        String svalue;

        GCMHandler(GraphContextMenu v, String s) {
            this.gcm = v;
            this.svalue = s;
        }

        public void actionPerformed(ActionEvent e) {
            this.gcm.itemSelected(this.svalue);
        }
    }
}

