/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.graph.gui;

import java.awt.BorderLayout;
import java.awt.Dimension;
import org.catacomb.graph.gui.BasePanel;
import org.catacomb.graph.gui.BuildPaintInstructor;
import org.catacomb.graph.gui.PaintInstructor;
import org.catacomb.graph.gui.PickListener;
import org.catacomb.graph.gui.PickWorldCanvas;
import org.catacomb.interlish.interact.ClickListener;

public class DrawingCanvas
extends BasePanel {
    static final long serialVersionUID = 1001L;
    PickWorldCanvas pwCanvas;

    public DrawingCanvas(int w, int h) {
        this.setPreferredSize(new Dimension(w, h));
        this.pwCanvas = new PickWorldCanvas(w, h - 20, true);
        this.setLayout(new BorderLayout());
        this.add("Center", this.pwCanvas);
    }

    public void setPaintInstructor(PaintInstructor pi) {
        this.pwCanvas.setPaintInstructor(pi);
    }

    public void setBuildPaintInstructor(BuildPaintInstructor bpi) {
        this.pwCanvas.setBuildPaintInstructor(bpi);
    }

    public void setPickListener(PickListener pl) {
        this.pwCanvas.setPickListener(pl);
    }

    public void setClickListener(ClickListener cl) {
        this.pwCanvas.setClickListener(cl);
    }

    public void attach(Object obj) {
        if (obj instanceof BuildPaintInstructor) {
            this.setBuildPaintInstructor((BuildPaintInstructor)obj);
        } else if (obj instanceof PaintInstructor) {
            this.setPaintInstructor((PaintInstructor)obj);
        }
        if (obj instanceof PickListener) {
            this.setPickListener((PickListener)obj);
        }
        if (obj instanceof ClickListener) {
            this.setClickListener((ClickListener)obj);
        }
    }

    public void setXRange(double low, double high) {
        this.pwCanvas.setXRange(low, high);
    }

    public void setFixedAspectRatio(double ar) {
        this.pwCanvas.setFixedAspectRatio(ar);
    }

    public void viewChanged() {
        if (this.pwCanvas != null) {
            this.pwCanvas.repaint();
        }
    }
}

