/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.graph.gui;

import org.catacomb.be.Position;
import org.catacomb.graph.gui.Painter;
import org.catacomb.graph.gui.PickStore;
import org.catacomb.graph.gui.PickablePoint;
import org.catacomb.graph.gui.PickableRegion;

public class Builder {
    Painter painter;
    PickStore pickStore;

    public Builder(Painter p, PickStore ps) {
        this.painter = p;
        this.pickStore = ps;
    }

    public void clear() {
        this.pickStore.clear();
    }

    public void addPoint(PickablePoint pp) {
        this.addPickablePoint(pp);
    }

    public void addPickablePoint(PickablePoint pp) {
        this.addPickablePoint(pp, pp.getPosition());
    }

    public void addPickablePoint(PickablePoint pp, Position pos) {
        int ix = this.painter.powx(pos.getX());
        int iy = this.painter.powy(pos.getY());
        this.pickStore.addPoint(pp, ix, iy);
        this.painter.fillPixelRectangle(ix, iy, pp.getColor(), pp.getSize());
    }

    public void addPickableRegion(PickableRegion pka) {
        this.pickStore.addPickableRegion(pka, this.painter.powx(pka.getXReference()), this.painter.powy(pka.getYReference()));
    }
}

