/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.graph.gui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import org.catacomb.graph.gui.BasePanel;
import org.catacomb.interlish.structure.Repaintable;
import org.catacomb.report.E;

public class BaseCanvas
extends BasePanel
implements Repaintable {
    static final long serialVersionUID = 1001L;
    int prefw;
    int prefh;
    Color bgColor;
    Color fgColor;
    BasicStroke bs1 = new BasicStroke(1.0f);

    public BaseCanvas(int w, int h) {
        this.bgColor = Color.black;
        this.fgColor = Color.white;
        this.setPreferredSize(new Dimension(w, h));
        this.prefw = w;
        this.prefh = h;
        this.setBackground(this.bgColor);
        this.setFont(new Font("sansserif", 0, 12));
    }

    public void setPreferredSize(int w, int h) {
        this.prefw = w;
        this.prefh = h;
        this.setPreferredSize(new Dimension(this.prefw, this.prefh));
    }

    public void setBg(Color c) {
        this.bgColor = c;
        this.setBackground(this.bgColor);
    }

    public void setCursor(String type) {
        if (type.equals("default") || type.equals("pointer")) {
            this.setCursor(new Cursor(0));
        } else if (type.equals("cross")) {
            this.setCursor(new Cursor(1));
        } else {
            E.warning("unrecognized cursor " + type);
        }
    }

    public Color getDataBackground() {
        return this.bgColor;
    }

    public Color getNormalForeground() {
        return this.fgColor;
    }

    public void paintComponent(Graphics g0) {
        g0.setColor(this.bgColor);
        g0.fillRect(0, 0, this.getWidth(), this.getHeight());
        Graphics2D g = (Graphics2D)g0;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.simpleStroke(g);
        this.paint2D(g);
    }

    final void simpleStroke(Graphics2D g) {
        g.setStroke(this.bs1);
    }

    public void paint2D(Graphics2D g) {
    }

    public void requestRepaint() {
        this.repaint();
    }
}

