/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.graph.drawing;

import org.catacomb.graph.drawing.FixedDrawingComponent;
import org.catacomb.graph.drawing.Shape;
import org.catacomb.graph.gui.Painter;

public class StraightLine
extends FixedDrawingComponent {
    public double x0;
    public double y0;
    public double x1;
    public double y1;

    public StraightLine() {
    }

    public StraightLine(double xa, double ya, double xb, double yb) {
        this.x0 = xa;
        this.y0 = ya;
        this.x1 = xb;
        this.y1 = yb;
    }

    public void instruct(Painter p, double offx, double offy, double scale) {
        p.drawLine(offx + scale * this.x0, offy + scale * this.y0, offx + scale * this.x1, offy + scale * this.y1, this.getColor(), this.getWidth(), this.widthIsPixels());
    }

    public void applyToShape(Shape shp) {
        shp.setClosure(0);
        shp.setCurviness(0.0);
        shp.setSymmetry(0);
        double[] xp = new double[]{this.x0, this.x1};
        shp.setXpts(xp);
        double[] yp = new double[]{this.y0, this.y1};
        shp.setYpts(yp);
    }

    public void scaleBy(double d) {
        this.x0 *= d;
        this.x1 *= d;
        this.y0 *= d;
        this.y1 *= d;
    }
}

