/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.graph.drawing;

import org.catacomb.be.Position;
import org.catacomb.graph.drawing.FixedDrawingComponent;
import org.catacomb.graph.drawing.Shape;
import org.catacomb.graph.gui.Painter;
import org.catacomb.report.E;
import org.catacomb.util.ArrayUtil;

public class GenericShape
extends FixedDrawingComponent {
    public double curviness;
    public String closure;
    public String symmetry;
    public double[] xpts;
    public double[] ypts;

    public GenericShape() {
    }

    public GenericShape(Shape sh, Position cpos, double scl) {
        double[][] bdry = sh.getBoundaryPoints();
        this.xpts = this.fromScaledPoints(bdry[0], cpos.getX(), scl);
        this.ypts = this.fromScaledPoints(bdry[1], cpos.getY(), scl);
        this.curviness = sh.getCurviness();
        this.setLineColor(sh.getLineColor());
        this.setLineWidth(sh.getLineWidth());
        if (sh.isFilled()) {
            this.setFilled();
            this.setFillColor(sh.getFillColor());
        } else if (sh.isClosed()) {
            this.setClosed();
        } else {
            this.setOpen();
        }
    }

    private double[] fromScaledPoints(double[] va, double c, double scl) {
        int n = va.length;
        double[] ret = new double[n];
        int i = 0;
        while (i < n) {
            ret[i] = (va[i] - c) / scl;
            ++i;
        }
        return ret;
    }

    public void reReference() {
        super.reReference();
        this.setFilled();
        if (this.closure != null) {
            if (this.closure.equals("open")) {
                this.setOpen();
            } else if (this.closure.equals("filled")) {
                this.setFilled();
            } else if (this.closure.equals("closed")) {
                this.setClosed();
            } else {
                E.warning("unrecognized closure " + this.closure);
            }
        }
    }

    public void instruct(Painter p, double offx, double offy, double scale) {
        int np = this.xpts.length;
        double[] xdr = new double[np];
        double[] ydr = new double[np];
        int i = 0;
        while (i < np) {
            xdr[i] = offx + scale * this.xpts[i];
            ydr[i] = offy + scale * this.ypts[i];
            ++i;
        }
        if (this.isFilled()) {
            p.fillPolygon(xdr, ydr, np, this.getFillColor());
        }
        if (this.p_width > 0.5) {
            if (this.isClosed() || this.isFilled()) {
                p.drawPolygon(xdr, ydr, np, this.p_color, this.p_width, true);
            } else {
                p.drawPolyline(xdr, ydr, np, this.p_color, this.p_width, true);
            }
        }
    }

    public void applyToShape(Shape shp) {
        shp.setCurviness(this.curviness);
        shp.setSymmetryString(this.symmetry);
        shp.setXpts(ArrayUtil.copyDArray(this.xpts));
        shp.setYpts(ArrayUtil.copyDArray(this.ypts));
    }
}

