/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.graph.drawing;

import java.awt.Color;
import java.util.ArrayList;
import org.catacomb.be.Position;
import org.catacomb.graph.drawing.FixedDrawingComponent;
import org.catacomb.graph.drawing.GenericShape;
import org.catacomb.graph.drawing.SegmentLine;
import org.catacomb.graph.drawing.Shape;
import org.catacomb.graph.drawing.Square;
import org.catacomb.graph.drawing.StraightLine;
import org.catacomb.graph.gui.Painter;
import org.catacomb.interlish.structure.AddableTo;
import org.catacomb.report.E;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FixedDrawing
implements AddableTo {
    public ArrayList<FixedDrawingComponent> items = new ArrayList();

    public void instruct(Painter p, double cx, double cy, double scale) {
        for (FixedDrawingComponent fdCpt : this.items) {
            fdCpt.instruct(p, cx, cy, scale);
        }
    }

    public void randomInit() {
        this.items.add(new Square(0.0, 0.0, 1.0, 1.0));
    }

    public ArrayList<Shape> makeShapes() {
        ArrayList<Shape> shapes = new ArrayList<Shape>();
        for (FixedDrawingComponent cpt : this.items) {
            Shape shp;
            if (cpt.isWrapper() || (shp = cpt.makeShape()) == null) continue;
            shapes.add(shp);
        }
        return shapes;
    }

    public void addFromScaledShape(Shape sh, Position cpos, double scl) {
        this.items.add(new GenericShape(sh, cpos, scl));
    }

    public ArrayList<Shape> makeOffsetShapes(double offx, double offy) {
        ArrayList<Shape> shapes = this.makeShapes();
        for (Shape shp : shapes) {
            shp.shiftExpand(offx, offy, 1.0);
        }
        return shapes;
    }

    @Override
    public void add(Object obj) {
        if (obj instanceof FixedDrawingComponent) {
            this.items.add((FixedDrawingComponent)obj);
        } else {
            E.error("wrong type in drawing " + obj);
        }
    }

    public ArrayList<FixedDrawingComponent> getComponents() {
        return this.items;
    }

    public void addStraightLine(double xa, double ya, double xb, double yb) {
        StraightLine sl = new StraightLine(xa, ya, xb, yb);
        this.items.add(sl);
    }

    public SegmentLine getBoundary() {
        double[] xp = new double[]{-1.0, 1.0, 1.0, -1.0, -1.0};
        double[] yp = new double[]{1.0, 1.0, -1.0, -1.0, 1.0};
        SegmentLine ret = new SegmentLine(xp, yp, Color.gray);
        return ret;
    }
}

