/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.graph.arbor;

import java.awt.Color;
import java.util.ArrayList;
import org.catacomb.be.Position;
import org.catacomb.graph.arbor.SGAttachmentPoint;
import org.catacomb.graph.gui.PickablePoint;
import org.catacomb.interlish.content.ConnectionFlavor;
import org.catacomb.interlish.structure.AttachmentPoint;
import org.catacomb.report.E;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SegmentGraphPoint
extends PickablePoint {
    int p_status;
    static final int PROTO = 1;
    static final int REAL = 2;
    public double x;
    public double y;
    public double radius;
    public String label;
    ArrayList<SegmentGraphPoint> p_neighbors;
    SegmentGraphPoint[] p_nbrCache;
    public int[] nbrIndexes;
    SegmentGraphPoint[] p_protoNbrs;
    SegmentGraphPoint p_extensionProto;
    SegmentGraphPoint p_pN1;
    SegmentGraphPoint p_pN2;
    int p_index;
    boolean p_highlight;
    boolean p_mark;

    public SegmentGraphPoint() {
        this(0.0, 0.0);
    }

    public SegmentGraphPoint(double x, double y) {
        this(x, y, 2);
    }

    public SegmentGraphPoint(double x, double y, int stat) {
        super(x, y);
        this.p_status = stat;
        if (this.p_status == 2) {
            this.setColor(Color.green);
        } else {
            this.setColor(Color.magenta);
        }
        this.radius = 1.0;
        this.p_neighbors = new ArrayList();
        if (this.isReal()) {
            this.syncExtensionProto();
        }
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public void deReference() {
        SegmentGraphPoint[] pa = this.getNeighbors();
        this.nbrIndexes = new int[pa.length];
        int i = 0;
        while (i < pa.length) {
            this.nbrIndexes[i] = pa[i].getIndex();
            ++i;
        }
        Position pos = this.getPosition();
        this.x = pos.getX();
        this.y = pos.getY();
    }

    public void reReference(ArrayList<SegmentGraphPoint> apa) {
        this.setPosition(this.x, this.y);
        this.p_neighbors = new ArrayList();
        if (this.nbrIndexes != null) {
            int i = 0;
            while (i < this.nbrIndexes.length) {
                this.p_neighbors.add(apa.get(this.nbrIndexes[i]));
                ++i;
            }
        }
        this.syncExtensionProto();
    }

    public AttachmentPoint makeAttachmentPoint() {
        SGAttachmentPoint sgap = new SGAttachmentPoint();
        sgap.setPosition(this.getPosition());
        sgap.setFlavor(new ConnectionFlavor("CellProbe"));
        sgap.setID("" + this.p_index);
        return sgap;
    }

    public SegmentGraphPoint[] getNeighbors() {
        if (this.p_nbrCache == null) {
            this.p_nbrCache = this.p_neighbors.toArray(new SegmentGraphPoint[0]);
        }
        return this.p_nbrCache;
    }

    public void setLabel(String s) {
        this.label = s;
    }

    public void highlightLabel(String s) {
        this.p_highlight = s.equals(this.label);
    }

    public boolean isReal() {
        return this.p_status == 2;
    }

    public void unHighlight() {
        this.p_highlight = false;
    }

    public void highlight() {
        this.p_highlight = true;
    }

    public boolean isHighlighted() {
        return this.p_highlight;
    }

    public void unMark() {
        this.p_mark = false;
    }

    public void mark() {
        this.p_mark = true;
    }

    public boolean isMarked() {
        return this.p_mark;
    }

    public void setIndex(int ind) {
        this.p_index = ind;
    }

    public int getIndex() {
        return this.p_index;
    }

    public void setRadius(double r) {
        this.radius = r;
    }

    public double getRadius() {
        return this.radius;
    }

    public double getR() {
        return this.getRadius();
    }

    public double getZ() {
        return 0.0;
    }

    public SegmentGraphPoint[] getProtoNeighbors() {
        if (this.p_protoNbrs == null) {
            SegmentGraphPoint[] pa = this.getNeighbors();
            this.p_protoNbrs = new SegmentGraphPoint[pa.length];
            int i = 0;
            while (i < pa.length) {
                if (this.getIndex() < pa[i].getIndex()) {
                    SegmentGraphPoint psgp = new SegmentGraphPoint(0.0, 0.0, 1);
                    psgp.setProtoNeighbors(this, pa[i]);
                    this.p_protoNbrs[i] = psgp;
                }
                ++i;
            }
        }
        return this.p_protoNbrs;
    }

    public void recHighlight() {
        SegmentGraphPoint[] nbrs = this.getNeighbors();
        this.highlight();
        int i = 0;
        while (i < nbrs.length) {
            if (!nbrs[i].isHighlighted()) {
                nbrs[i].recHighlight();
            }
            ++i;
        }
    }

    public boolean recHighlightPath() {
        SegmentGraphPoint[] nbrs = this.getNeighbors();
        this.mark();
        boolean bret = false;
        if (this.isHighlighted()) {
            bret = true;
        } else {
            int i = 0;
            while (i < nbrs.length) {
                if (!nbrs[i].isMarked() && nbrs[i].recHighlightPath()) {
                    bret = true;
                    break;
                }
                ++i;
            }
        }
        if (bret) {
            this.highlight();
        }
        return bret;
    }

    public void move(Position pos) {
        SegmentGraphPoint[] pa = this.getNeighbors();
        this.setPosition(pos);
        if (this.isReal()) {
            this.p_extensionProto.updateProtoPosition();
            this.updateProtos();
            int i = 0;
            while (i < pa.length) {
                pa[i].updateProtos();
                ++i;
            }
        }
    }

    public void updateProtos() {
        SegmentGraphPoint[] ppa = this.getProtoNeighbors();
        int i = 0;
        while (i < ppa.length) {
            if (ppa[i] != null) {
                ppa[i].updateProtoPosition();
            }
            ++i;
        }
    }

    public void realize() {
        if (this.isReal()) {
            E.error(" - tried to realized real pt");
            return;
        }
        this.p_status = 2;
        this.setColor(Color.green);
        if (this.p_pN2 == null) {
            this.setRadius(this.p_pN1.getRadius());
            this.connectTo(this.p_pN1);
            this.p_pN1.syncExtensionProto();
        } else {
            this.p_pN1.removeNeighbor(this.p_pN2);
            this.p_pN2.removeNeighbor(this.p_pN1);
            this.connectTo(this.p_pN1);
            this.connectTo(this.p_pN2);
            this.setRadius((this.p_pN1.getRadius() + this.p_pN2.getRadius()) / 2.0);
        }
        this.p_pN1 = null;
        this.p_pN2 = null;
        this.syncExtensionProto();
    }

    public void connectTo(SegmentGraphPoint sgp) {
        this.addNeighbor(sgp);
        sgp.addNeighbor(this);
    }

    public SegmentGraphPoint getExtensionProto() {
        return this.p_extensionProto;
    }

    public void removeExtensionProto() {
        this.p_extensionProto = null;
    }

    public void syncExtensionProto() {
        if (this.p_extensionProto == null || this.p_extensionProto.isReal()) {
            Position ppos = this.getPosition();
            this.p_extensionProto = new SegmentGraphPoint(ppos.getX(), ppos.getY() - 1.5 * this.radius, 1);
            this.p_extensionProto.setProtoNeighbors(this, null);
        }
        this.p_extensionProto.updateProtoPosition();
    }

    public void setProtoNeighbors(SegmentGraphPoint sgp1, SegmentGraphPoint sgp2) {
        this.p_pN1 = sgp1;
        this.p_pN2 = sgp2;
        this.updateProtoPosition();
    }

    public void updateProtoPosition() {
        if (this.isReal()) {
            E.error(" - called update proto on real point");
        } else {
            Position p1 = this.p_pN1.getPosition();
            double x1 = p1.getX();
            double y1 = p1.getY();
            double r1 = this.p_pN1.getRadius();
            if (this.p_pN2 == null) {
                this.setPosition(x1, y1 - 1.5 * r1);
            } else {
                Position p2 = this.p_pN2.getPosition();
                double x2 = p2.getX();
                double y2 = p2.getY();
                this.setPosition((x1 + x2) / 2.0, (y1 + y2) / 2.0);
            }
        }
    }

    private void addNeighbor(SegmentGraphPoint sgp) {
        this.p_neighbors.add(sgp);
        this.p_nbrCache = null;
        this.p_protoNbrs = null;
    }

    private void removeNeighbor(SegmentGraphPoint sgp) {
        this.p_neighbors.remove(sgp);
        this.p_nbrCache = null;
        this.p_protoNbrs = null;
    }
}

