/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.graph.arbor;

import java.awt.Color;
import org.catacomb.be.Position;
import org.catacomb.graph.arbor.SegmentGraph;
import org.catacomb.graph.arbor.SegmentGraphPoint;
import org.catacomb.graph.gui.BuildPaintInstructor;
import org.catacomb.graph.gui.Builder;
import org.catacomb.graph.gui.Painter;

public class SegmentGraphPainter
implements BuildPaintInstructor {
    SegmentGraph graph;
    boolean b_antialias = false;
    SegmentGraphPoint sgp1;
    SegmentGraphPoint sgp2;
    boolean b_live = true;

    public void setSegmentGraph(SegmentGraph sg) {
        this.graph = sg;
    }

    public void setBuildPoints(boolean b) {
        this.b_live = b;
    }

    public void setAntialias(boolean b) {
        this.b_antialias = b;
    }

    public boolean antialias() {
        return this.b_antialias;
    }

    public void instruct(Painter painter, Builder builder) {
        if (this.graph == null) {
            return;
        }
        for (SegmentGraphPoint sgp : this.graph.getPoints()) {
            this.paintReal(sgp, painter, builder);
        }
    }

    public void paintReal(SegmentGraphPoint sgp, Painter painter, Builder builder) {
        if (this.b_live) {
            builder.addPoint(sgp);
        }
        SegmentGraphPoint[] nbrs = sgp.getNeighbors();
        int index = sgp.getIndex();
        painter.setColor(Color.white);
        painter.drawCircle(sgp.getPosition(), sgp.getRadius());
        int i = 0;
        while (i < nbrs.length) {
            if (nbrs[i].getIndex() > index) {
                painter.setColor(Color.white);
                this.drawSegment(painter, sgp, nbrs[i]);
            }
            ++i;
        }
    }

    public void drawSegment(Painter painter, SegmentGraphPoint sgpa, SegmentGraphPoint sgpb) {
        Position posa = sgpa.getPosition();
        double x1 = posa.getX();
        double y1 = posa.getY();
        double r1 = sgpa.getRadius();
        Position posb = sgpb.getPosition();
        double x2 = posb.getX();
        double y2 = posb.getY();
        double r2 = sgpb.getRadius();
        painter.drawCarrotSides(x1, y1, r1, x2, y2, r2);
    }
}

