/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.druid.xtext.data;

import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import org.catacomb.druid.xtext.base.DMItem;
import org.catacomb.druid.xtext.base.Guise;
import org.catacomb.druid.xtext.data.XRelationType;
import org.catacomb.druid.xtext.data.XType;
import org.catacomb.report.E;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XTypeStore
extends DMItem {
    static XTypeStore p_instance;
    ArrayList<XType> types = new ArrayList();
    HashMap<String, XType> typeHM = new HashMap();
    ArrayList<XRelationType> relations = new ArrayList();
    HashMap<String, XRelationType> relationHM = new HashMap();
    XType typeType;
    XType propertyType;
    XType relType;
    XType thingType;

    public static XTypeStore instance() {
        if (p_instance == null) {
            p_instance = new XTypeStore();
        }
        return p_instance;
    }

    public void addType(String s) {
        if (this.typeHM.containsKey(s)) {
            E.error("already have a type " + s);
        } else {
            XType xt = new XType(s);
            this.addType(xt);
        }
    }

    private void addType(XType xt) {
        this.types.add(xt);
        this.typeHM.put(xt.getID(), xt);
        xt.setParent(this);
        this.notifyAppearanceChange();
    }

    public ArrayList<XType> getTypes() {
        return this.types;
    }

    public XType getType(String ntn) {
        return this.typeHM.get(ntn);
    }

    public Guise getGuise(String ntn) {
        XType typ = this.getType(ntn);
        return typ.getGuise();
    }

    public void remove(XType typ) {
        this.types.remove(typ);
        this.typeHM.remove(typ.getID());
        this.notifyAppearanceChange();
    }

    public void remove(XRelationType typ) {
        this.relations.remove(typ);
        this.relationHM.remove(typ.getID());
        this.notifyAppearanceChange();
    }

    public void addRelationType(XRelationType xrt) {
        if (this.relationHM.containsKey(xrt.getID())) {
            E.error("already have a relation " + xrt.getID());
        } else {
            this.relations.add(xrt);
            this.relationHM.put(xrt.getID(), xrt);
        }
        this.notifyAppearanceChange();
    }

    public XType getTypeType() {
        if (this.typeType == null) {
            this.typeType = new XType("type");
            this.typeType.getGuise().setFontStyle("italic");
            this.typeType.getGuise().setColorBlack();
            this.typeType.getGuise().setUnderline(true);
        }
        return this.typeType;
    }

    public XType getPropertyType() {
        if (this.propertyType == null) {
            this.propertyType = new XType("property");
            this.propertyType.getGuise().setFontStyle("bold");
            this.propertyType.getGuise().setColorDarkGreen();
        }
        return this.propertyType;
    }

    public XType getRelType() {
        if (this.relType == null) {
            this.relType = new XType("rel");
            this.relType.getGuise().setFontStyle("bold");
            this.relType.getGuise().setFontColor(new Color(120, 20, 20));
            this.relType.getGuise().setUnderline(true);
        }
        return this.relType;
    }

    public XType getThingType() {
        if (this.thingType == null) {
            this.thingType = new XType("rel");
            this.thingType.getGuise().setFontStyle("bold");
            this.thingType.getGuise().setFontColor(new Color(80, 80, 80));
        }
        return this.thingType;
    }

    public ArrayList<XRelationType> getRelationTypes() {
        return this.relations;
    }

    public void addIfNew(XType xt) {
        if (!this.typeHM.containsKey(xt.getID())) {
            this.addType(xt);
        }
    }

    public void addIfNew(XRelationType xrt) {
        if (!this.relationHM.containsKey(xrt.getID())) {
            this.addRelationType(xrt);
        }
    }
}

