/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.druid.xtext.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import org.catacomb.druid.xtext.base.DocStore;
import org.catacomb.druid.xtext.data.XItem;
import org.catacomb.druid.xtext.data.XRelation;
import org.catacomb.druid.xtext.data.XRelationType;
import org.catacomb.druid.xtext.data.XType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageDataStore {
    HashMap<XType, ArrayList<XItem>> itemHM;
    ArrayList<XRelation> relations;
    HashMap<XRelationType, ArrayList<XRelation>> relationHM;
    DocStore docStore;

    public PageDataStore(DocStore ds) {
        this.docStore = ds;
        this.itemHM = new HashMap();
        this.relationHM = new HashMap();
        this.relations = new ArrayList();
    }

    public void addItem(XType xt, String text) {
        XItem xit = new XItem(xt, text);
        this.addItem(xit);
    }

    public void addItem(XItem xit) {
        if (this.itemHM.containsKey(xit.getType())) {
            this.itemHM.get(xit.getType()).add(xit);
        } else {
            ArrayList<XItem> al = new ArrayList<XItem>();
            al.add(xit);
            this.itemHM.put(xit.getType(), al);
        }
        this.reportChange();
    }

    public void reportChange() {
        this.docStore.pageDataChanged();
    }

    public Set<XType> getTypes() {
        return this.itemHM.keySet();
    }

    public ArrayList<XItem> getList(XType xt) {
        return this.itemHM.get(xt);
    }

    public Collection<ArrayList<XItem>> getLists() {
        return this.itemHM.values();
    }

    public void addRelation(XRelation xr) {
        this.relations.add(xr);
        if (this.relationHM.containsKey(xr.getRelationType())) {
            this.relationHM.get(xr.getRelationType()).add(xr);
        } else {
            ArrayList<XRelation> al = new ArrayList<XRelation>();
            al.add(xr);
            this.relationHM.put(xr.getRelationType(), al);
        }
        this.reportChange();
    }

    public ArrayList<XRelation> getRelations() {
        return this.relations;
    }

    public boolean hasRelations() {
        return this.relations.size() > 0;
    }
}

