/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.druid.xtext.canvas;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import org.catacomb.druid.xtext.base.Block;
import org.catacomb.druid.xtext.base.PunctuationBlock;
import org.catacomb.druid.xtext.base.TextBlock;
import org.catacomb.druid.xtext.base.WordBlock;
import org.catacomb.druid.xtext.canvas.TextBoard;
import org.catacomb.report.E;

public class KeyWriter
implements KeyListener {
    TextBoard textBoard;
    int keyCode;
    TextBlock caretBlock;
    int caretPos;

    public KeyWriter(TextBoard tb) {
        this.textBoard = tb;
    }

    public TextBlock getCaretBlock() {
        return this.caretBlock;
    }

    public int getCaretPos() {
        return this.caretPos;
    }

    public void setCaretBlock(TextBlock tb) {
        this.caretBlock = tb;
    }

    public void setCaretPos(int ip) {
        this.caretPos = ip;
    }

    public void keyPressed(KeyEvent e) {
        this.keyCode = e.getKeyCode();
        switch (this.keyCode) {
            case 37: {
                this.caretLeft();
                break;
            }
            case 39: {
                this.caretRight();
                break;
            }
            case 38: {
                this.caretUp();
                break;
            }
            case 40: {
                this.caretDown();
                break;
            }
            case 8: {
                this.deletBackwards();
                break;
            }
            case 10: {
                this.newline();
            }
        }
    }

    public void keyTyped(KeyEvent e) {
        if (e.isActionKey()) {
            E.info("action key " + KeyEvent.getKeyText(this.keyCode));
        } else {
            char c = e.getKeyChar();
            this.insertCharacter(c);
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void caretLeft() {
        if (this.caretBlock == null) {
            return;
        }
        if (this.caretPos > 0) {
            --this.caretPos;
        } else {
            TextBlock tb = this.caretBlock.previousTextBlock();
            if (tb != null) {
                this.caretBlock = tb;
                this.caretPos = this.caretBlock.textLength() - 1;
            }
        }
        this.textBoard.repaint();
    }

    public void caretRight() {
        if (this.caretBlock == null) {
            return;
        }
        if (this.caretPos < this.caretBlock.textLength()) {
            ++this.caretPos;
        } else {
            TextBlock tb = this.caretBlock.nextTextBlock();
            if (tb != null) {
                this.caretBlock = tb;
                this.caretPos = 1;
            }
        }
        this.textBoard.repaint();
    }

    public void caretUp() {
        if (this.caretBlock == null) {
            return;
        }
    }

    public void caretDown() {
        if (this.caretBlock == null) {
            return;
        }
    }

    public void insertCharacter(char c) {
        String s = "" + c;
        if (Character.isLetter(c)) {
            this.insertLetter(c);
            this.textBoard.repaint();
        } else if (" .,;:?!\t\n".indexOf(s) >= 0) {
            this.insertPunctuation(c);
            this.textBoard.repaint();
        }
    }

    private void insertLetter(char c) {
        if (this.caretBlock instanceof WordBlock) {
            this.insertLetterInWord(this.caretBlock, c, this.caretPos);
        } else if (this.caretPos == 0) {
            this.insertLetterBeforeNonWord(this.caretBlock, c);
        } else if (this.caretPos == this.caretBlock.textLength()) {
            this.insertLetterAfterNonWord(this.caretBlock, c);
        } else {
            this.insertLetterInNonWord(this.caretBlock, c, this.caretPos);
        }
    }

    private void insertLetterInWord(TextBlock tb, char c, int cp) {
        tb.insertCharacter(c, cp);
        this.caretBlock = tb;
        this.caretPos = cp + 1;
    }

    private void insertLetterInNonWord(TextBlock tb, char c, int cp) {
        WordBlock wb = new WordBlock();
        wb.setText("" + c);
        tb.insert(wb, cp);
        this.caretBlock = wb;
        this.caretPos = 1;
    }

    private void insertLetterBeforeNonWord(TextBlock tb, char c) {
        TextBlock bpr = tb.previousTextBlock();
        if (bpr instanceof WordBlock) {
            this.insertLetterInWord(bpr, c, bpr.textLength());
        } else {
            this.addNewWordBlockAfter(bpr, c);
        }
    }

    private void addNewWordBlockAfter(TextBlock bpr, char c) {
        WordBlock wb = new WordBlock();
        wb.setText("" + c);
        Block bnx = bpr.next();
        bpr.setNext(wb);
        wb.setNext(bnx);
        this.caretBlock = wb;
        this.caretPos = 1;
    }

    private void insertLetterAfterNonWord(TextBlock tb, char c) {
        TextBlock bnx = tb.nextTextBlock();
        if (bnx instanceof WordBlock) {
            this.insertLetterInWord(bnx, c, 0);
        } else {
            this.addNewWordBlockAfter(tb, c);
        }
    }

    private void insertPuncInPunc(TextBlock tb, char c, int cp) {
        tb.insertCharacter(c, cp);
        this.caretBlock = tb;
        this.caretPos = cp + 1;
    }

    private void insertPunctuation(char c) {
        if (this.caretBlock instanceof PunctuationBlock) {
            this.insertPuncInPunc(this.caretBlock, c, this.caretPos);
        } else if (this.caretPos == 0) {
            this.insertPuncBeforeNonPunc(this.caretBlock, c);
        } else if (this.caretPos == this.caretBlock.textLength()) {
            this.insertPuncAfterNonPunc(this.caretBlock, c);
        } else {
            this.insertPuncInNonPunc(this.caretBlock, c, this.caretPos);
        }
    }

    private void insertPuncInNonPunc(TextBlock tb, char c, int cp) {
        PunctuationBlock wb = new PunctuationBlock();
        wb.setText("" + c);
        tb.insert(wb, cp);
        this.caretBlock = wb;
        this.caretPos = 1;
    }

    private void insertPuncBeforeNonPunc(TextBlock tb, char c) {
        TextBlock bpr = tb.previousTextBlock();
        if (bpr instanceof PunctuationBlock) {
            this.insertPuncInPunc(bpr, c, bpr.textLength());
        } else {
            this.addNewPuncBlockAfter(bpr, c);
        }
    }

    private void addNewPuncBlockAfter(TextBlock bpr, char c) {
        PunctuationBlock wb = new PunctuationBlock();
        wb.setText("" + c);
        Block bnx = bpr.next();
        bpr.setNext(wb);
        wb.setNext(bnx);
        this.caretBlock = wb;
        this.caretPos = 1;
    }

    private void insertPuncAfterNonPunc(TextBlock tb, char c) {
        TextBlock bnx = tb.nextTextBlock();
        if (bnx instanceof PunctuationBlock) {
            this.insertPuncInPunc(bnx, c, 0);
        } else {
            this.addNewPuncBlockAfter(tb, c);
        }
    }

    public void deletBackwards() {
        TextBlock tb;
        if (this.caretPos == 0) {
            tb = this.caretBlock.previousTextBlock();
            if (tb == null) {
                return;
            }
            this.caretBlock = tb;
            this.caretPos = this.caretBlock.textLength();
        }
        if (this.caretBlock.textLength() == 1) {
            tb = this.caretBlock.previousTextBlock();
            int newPos = tb.textLength();
            this.caretBlock.remove();
            if (tb == null) {
                this.caretBlock = this.textBoard.firstTextBlock();
                this.caretPos = 0;
            } else {
                this.caretBlock = tb;
                this.caretPos = newPos;
            }
        } else {
            this.caretBlock.deleteCharBefore(this.caretPos);
            --this.caretPos;
        }
        this.textBoard.repaint();
    }

    private void newline() {
        if (this.caretPos == 0) {
            TextBlock tbp = this.caretBlock.previousTextBlock();
            if (tbp != null) {
                tbp.newlineAfter();
            }
        } else if (this.caretPos == this.caretBlock.textLength()) {
            this.caretBlock.newlineAfter();
            this.caretBlock = this.caretBlock.nextTextBlock();
            this.caretPos = 1;
        } else {
            this.caretBlock.insertNewline(this.caretPos);
            this.caretBlock = this.caretBlock.nextTextBlock();
            this.caretPos = 1;
        }
    }

    public boolean hasCaret() {
        return this.caretBlock != null;
    }
}

