/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.druid.util;

import java.io.File;
import java.util.HashMap;
import org.catacomb.druid.swing.DFileChooser;
import org.catacomb.interlish.service.AppPersist;

public class FileChooser {
    static FileChooser chooser;
    DFileChooser dFileChooser = new DFileChooser();
    HashMap<String, File> hmap = new HashMap();

    public static FileChooser getChooser() {
        if (chooser == null) {
            chooser = new FileChooser();
        }
        return chooser;
    }

    public void addExtensionFilter(String exts, String desc) {
        this.dFileChooser.addExtensionFilter(exts, desc);
    }

    public File getFileToImport() {
        return this.getFile("import", "import");
    }

    public File getFileToOpen(String mode) {
        return this.getFile(mode, "open");
    }

    public File getFileToWrite(String mode) {
        return this.getFile(mode, "save");
    }

    private void applyMode(String mode) {
        if (this.hmap.containsKey(mode)) {
            File fdir = this.hmap.get(mode);
            this.dFileChooser.setRootDirectory(fdir);
        } else {
            String path;
            File fpar;
            String pel = "LastDir" + mode;
            if (AppPersist.hasValueFor(pel) && (fpar = new File(path = AppPersist.getValueFor(pel))).exists() && fpar.isDirectory()) {
                this.dFileChooser.setRootDirectory(fpar);
            }
        }
    }

    public File getFile(String mode, String approve) {
        this.applyMode(mode);
        this.dFileChooser.setApproveButtonText(approve);
        int retval = this.dFileChooser.showDialog(null, approve);
        File f = null;
        if (retval == 0) {
            f = this.dFileChooser.getSelectedFile();
        }
        this.cacheDir(f, mode);
        return f;
    }

    private void cacheDir(File f, String mode) {
        if (f != null) {
            File fpar = f;
            if (!f.isDirectory()) {
                fpar = f.getParentFile();
            }
            String path = fpar.getAbsolutePath();
            AppPersist.setValue("LastDir" + mode, path);
            this.hmap.put(mode, fpar);
        }
    }

    public File getDirectory(File fdir, String approve) {
        this.dFileChooser.setSelectDirectories();
        if (fdir != null) {
            this.dFileChooser.setSelectedFile(fdir);
        }
        File fret = this.getDirectory(approve);
        this.cacheDir(fret, "default");
        return fret;
    }

    public File getDirectory(String mode, String approve) {
        this.applyMode(mode);
        File fret = this.getDirectory(approve);
        this.cacheDir(fret, mode);
        return fret;
    }

    private File getDirectory(String approve) {
        this.dFileChooser.setSelectDirectories();
        this.dFileChooser.setApproveButtonText(approve);
        int retval = this.dFileChooser.showDialog(null, approve);
        File f = null;
        if (retval == 0) {
            f = this.dFileChooser.getSelectedFile();
        }
        if (f != null && !f.isDirectory()) {
            f = new File(f.getParent());
        }
        return f;
    }

    public File getFolder(File fdef) {
        return this.getDirectory(fdef, "select");
    }
}

