/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.druid.swing.dnd;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import org.catacomb.druid.swing.DTextCanvas;
import org.catacomb.druid.swing.dnd.ClickableRegionStore;
import org.catacomb.druid.swing.dnd.InternalTransferHandler;
import org.catacomb.druid.swing.dnd.Region;
import org.catacomb.druid.swing.dnd.RegionDragSource;
import org.catacomb.druid.swing.dnd.RegionDropTarget;
import org.catacomb.druid.swing.dnd.RegionListener;
import org.catacomb.interlish.structure.ChangeNotifiable;
import org.catacomb.report.E;

public class RegionBoard
implements FocusListener,
RegionListener {
    protected DTextCanvas canvas;
    ChangeNotifiable changeNotifiable;
    private ClickableRegionStore crStore;
    boolean inFocus;
    RegionDropTarget dropTarget;
    RegionDragSource dragSource;
    protected int fullTextHeight = 100;

    public RegionBoard(DTextCanvas c) {
        this.canvas = c;
        this.crStore = new ClickableRegionStore(c);
        this.crStore.setRegionListener(this);
        this.canvas.addFocusListener(this);
        this.dropTarget = new RegionDropTarget(this);
        this.dragSource = new RegionDragSource(this, 3);
        this.canvas.setTransferHandler(new InternalTransferHandler());
    }

    public DTextCanvas getCanvas() {
        return this.canvas;
    }

    public void clearRegions() {
        this.crStore.clear();
    }

    public void requestFocus() {
        this.canvas.requestFocusInWindow();
    }

    public void setAntialias(boolean b) {
        this.canvas.setAntialias(b);
    }

    public void repaint() {
        this.canvas.repaint();
    }

    public int getWidth() {
        return this.canvas.getWidth();
    }

    public int getHeight() {
        return this.canvas.getHeight();
    }

    public void setChangeNotifiable(ChangeNotifiable cn) {
        this.changeNotifiable = cn;
    }

    public void notifyChange(Object obj) {
        if (this.changeNotifiable != null) {
            this.changeNotifiable.changed(obj);
        }
    }

    public void prePaintRegions(Graphics2D g) {
        if (this.inFocus) {
            g.setColor(Color.white);
            g.drawRect(1, 1, this.canvas.getWidth() - 2, this.canvas.getHeight() - 2);
        }
    }

    protected void addLengthenedRegion(int[] cachedPosition, Object b) {
        this.crStore.addLengthenedRegion(cachedPosition, b);
    }

    protected void addClickRegion(int[] xywh, Object b, String s) {
        this.crStore.addRegion(xywh, b, s, 0);
    }

    protected void addDragRegion(int[] xywh, Object b, String s) {
        this.crStore.addRegion(xywh, b, s, 1);
    }

    protected void addDropRegion(int[] xywh, Object b, String s) {
        this.crStore.addRegion(xywh, b, s, 2);
    }

    protected void addDragOrDropRegion(int[] xywh, Object b, String s) {
        this.crStore.addRegion(xywh, b, s, 3);
    }

    protected void addRegion(int x, int y, int w, int h, Object obj, String s) {
        this.crStore.addRegion(x, y, w, h, obj, s, 0);
    }

    protected void addRegion(int x, int y, int w, int h, Object obj, String s, int ity) {
        this.crStore.addRegion(x, y, w, h, obj, s, ity);
    }

    public Region getDragOverRegion(int x, int y) {
        this.crStore.dragOver(x, y);
        return this.crStore.getDragOverRegion();
    }

    public Region getDragOverRegion() {
        return this.crStore.getDragOverRegion();
    }

    public void dropOn(Object src, Region target) {
        E.info("item dropped on region " + src + " " + target);
    }

    public void regionClicked(Region reg) {
        E.override("click regoin " + reg);
    }

    boolean hasFocus() {
        return this.inFocus;
    }

    public void focusGained(FocusEvent e) {
        this.inFocus = true;
        this.repaint();
    }

    public void focusLost(FocusEvent e) {
        this.inFocus = false;
        this.repaint();
    }

    public Region getHoverRegion() {
        return this.crStore.getHoverRegion();
    }

    public void unecho(Region reg) {
        this.crStore.unecho(reg);
    }

    public void dropGeneral(Object dropee) {
        E.override();
    }

    public int getFullTextHeight() {
        return this.fullTextHeight;
    }
}

