/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.druid.swing;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetContext;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.image.BufferedImage;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.catacomb.druid.swing.DTree;
import org.catacomb.druid.swing.ImageDragSource;
import org.catacomb.druid.swing.dnd.DragAndDrop;
import org.catacomb.report.E;

public class DTreeDropTarget
implements DropTargetListener {
    DropTarget target;
    DTree targetTree;
    Rectangle dragBounds;

    public DTreeDropTarget(DTree tree) {
        this.targetTree = tree;
        this.target = new DropTarget(this.targetTree, this);
    }

    private Object getNodeForEvent(DropTargetDragEvent dtde) {
        Point p = dtde.getLocation();
        DropTargetContext dtc = dtde.getDropTargetContext();
        JTree tree = (JTree)dtc.getComponent();
        TreePath path = tree.getClosestPathForLocation(p.x, p.y);
        return path.getLastPathComponent();
    }

    public void dragEnter(DropTargetDragEvent dtde) {
        E.info("drag entered " + dtde);
        dtde.rejectDrag();
    }

    public void dragOver(DropTargetDragEvent dtde) {
        if (this.dragBounds != null) {
            this.targetTree.paintImmediately(this.dragBounds);
        } else {
            this.dragBounds = new Rectangle();
        }
        Point p = dtde.getLocation();
        DragAndDrop obj = DragAndDrop.getDnD();
        if (obj instanceof ImageDragSource) {
            ImageDragSource ids = obj;
            BufferedImage bim = ids.getDragImage();
            Point poff = ids.getDragImageOffset();
            if (bim == null) {
                E.warning("no drag image?");
            } else {
                this.dragBounds.setRect(p.x - poff.x, p.y - poff.y, bim.getWidth(), bim.getHeight());
                Graphics g = this.targetTree.getGraphics();
                g.drawImage(bim, (int)this.dragBounds.getX(), (int)this.dragBounds.getY(), null);
            }
        } else {
            E.warning("wrong type of source " + obj);
        }
        dtde.rejectDrag();
    }

    public void dragExit(DropTargetEvent dte) {
        if (this.dragBounds != null) {
            this.targetTree.paintImmediately(this.dragBounds);
        }
    }

    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    public void drop(DropTargetDropEvent dtde) {
    }
}

