/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.druid.swing;

import java.awt.Color;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import org.catacomb.druid.swing.DMenu;
import org.catacomb.druid.swing.DTreeDragSource;
import org.catacomb.druid.swing.DTreeDropTarget;
import org.catacomb.druid.swing.DTreeModel;
import org.catacomb.druid.swing.EmptyTree;
import org.catacomb.druid.swing.TCRenderer;
import org.catacomb.druid.swing.dnd.InternalTransferHandler;
import org.catacomb.druid.swing.ui.DruidTreeUI;
import org.catacomb.interlish.structure.SelectionActor;
import org.catacomb.interlish.structure.Tree;

public class DTree
extends JTree
implements TreeSelectionListener,
MouseListener {
    static final long serialVersionUID = 1001L;
    public SelectionActor selectionActor;
    DTreeDragSource dTreeDragSource;
    DTreeDropTarget dTreeDropTarget;
    DTreeModel dTreeModel;
    DMenu dMenu;
    boolean p_doneMouseListener = false;
    TCRenderer renderer;

    public DTree() {
        this.setForeground(Color.black);
        this.setUI(new DruidTreeUI());
        this.init();
        this.addTreeSelectionListener(this);
    }

    public void setSelectionActor(SelectionActor sa) {
        this.selectionActor = sa;
    }

    public void valueChanged(TreeSelectionEvent e) {
        Object obj = this.getLastSelectedPathComponent();
        if (this.selectionActor != null) {
            this.selectionActor.selectionAction(obj, "DTree");
        }
    }

    public void setBg(Color c) {
        this.setBackground(c);
        this.renderer.setBackgroundNonSelectionColor(c);
    }

    public void init() {
        this.getSelectionModel().setSelectionMode(1);
        this.renderer = new TCRenderer();
        this.setCellRenderer(this.renderer);
    }

    public void setTree(Tree tree) {
        this.dTreeModel = new DTreeModel(tree);
        this.setModel(this.dTreeModel);
    }

    public void clear() {
        this.setModel(new DTreeModel(new EmptyTree()));
    }

    public void dTreeExpandPath(Object[] oa) {
        TreePath tp = new TreePath(oa);
        this.expandPath(tp);
    }

    public void setSelected(Object[] oa) {
        TreePath tp = new TreePath(oa);
        this.setSelectionPath(tp);
    }

    public void setMenu(DMenu dm) {
        if (!this.p_doneMouseListener) {
            this.addMouseListener(this);
            this.p_doneMouseListener = true;
        }
        this.dMenu = dm;
    }

    public void mousePressed(MouseEvent e) {
        int modif = e.getModifiers();
        if (this.dMenu != null) {
            this.dMenu.preShowSync();
            if ((modif & 4) != 0) {
                this.dMenu.getPopupMenu().show(this, e.getX(), e.getY());
            }
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void enableDrag() {
        if (this.dTreeDragSource == null) {
            this.dTreeDragSource = new DTreeDragSource(this, 3);
        }
        if (this.dTreeDropTarget == null) {
            this.dTreeDropTarget = new DTreeDropTarget(this);
        }
        this.setTransferHandler(new InternalTransferHandler());
        this.setDragEnabled(true);
    }

    public void ensureVisible(String sfc) {
    }
}

