/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.druid.swing;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.catacomb.druid.event.PanelListener;
import org.catacomb.interlish.interact.DComponent;
import org.catacomb.report.E;
import org.catacomb.util.ColorUtil;

public class DTabbedPane
extends JTabbedPane
implements DComponent,
ChangeListener {
    static final long serialVersionUID = 1001L;
    public PanelListener pListener;
    int ntab;
    String[] tabNames;
    boolean dontReport = false;

    public DTabbedPane() {
        this.addChangeListener(this);
        this.ntab = 0;
        this.tabNames = new String[20];
    }

    public void setTooltip(String s) {
        this.setToolTipText(s);
    }

    public static void applyUIColors(Color c) {
        Color cbr = ColorUtil.slightlyBrighter(c);
        Color cdk = ColorUtil.slightlyDarker(c);
        Color cdkdk = ColorUtil.slightlyDarker(cdk);
        UIManager.put("TabbedPane.contentAreaColor", c);
        UIManager.put("TabbedPane.selected", c);
        UIManager.put("TabbedPane.selectedBackground", c);
        UIManager.put("TabbedPane.unselectedBackground", cdk);
        UIManager.put("TabbedPane.tabAreaBackground", c);
        UIManager.put("TabbedPane.selectHighlight", cbr);
        UIManager.put("TabbedPane.tabsOpaque", new Boolean(false));
        UIManager.put("TabbedPane.borderHightlightColor", cdk);
        UIManager.put("TabbedPane.light", cbr);
        UIManager.put("TabbedPane.highlight", cbr);
        UIManager.put("TabbedPane.shadow", cdk);
        UIManager.put("TabbedPane.darkShadow", cdkdk);
        UIManager.put("TabbedPane.focus", c);
    }

    public void select(Object obj) {
        this.setSelectedComponent((Component)obj);
        this.report();
    }

    private void report() {
        if (!this.dontReport && this.pListener != null) {
            Component obj = this.getSelectedComponent();
            this.pListener.panelShown(obj);
        }
    }

    public void setBg(Color c) {
        this.setBackground(c);
    }

    public void setFg(Color c) {
        this.setForeground(c);
    }

    public void setPanelListener(PanelListener pl) {
        this.pListener = pl;
    }

    public void stateChanged(ChangeEvent cev) {
        this.report();
    }

    public void addTab(String s, Component c) {
        super.addTab(s, c);
        E.error("shouldn't use");
    }

    public void addTab(String s, Component c, String tooltip) {
        this.dontReport = true;
        super.addTab(s, null, c, tooltip);
        this.setBackgroundAt(this.ntab, null);
        this.tabNames[this.ntab++] = s;
        this.dontReport = false;
    }

    public void showTab(String s) {
        boolean done = false;
        int i = 0;
        while (i < this.ntab) {
            if (this.tabNames[i].equals(s)) {
                done = true;
                this.setSelectedIndex(i);
            }
            ++i;
        }
        if (!done) {
            E.error("no such tab " + s);
            i = 0;
            while (i < this.ntab) {
                E.info("tab " + i + " has name " + this.tabNames[i]);
                ++i;
            }
        }
    }
}

