/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.druid.swing;

import java.awt.CardLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;
import org.catacomb.druid.event.LabelActor;
import org.catacomb.druid.swing.DPanel;
import org.catacomb.report.E;

public class DRadioButtons
extends DPanel
implements ActionListener {
    static final long serialVersionUID = 1001L;
    LabelActor lact;
    String selected;
    String[] options;
    String[] labels;
    JRadioButton[] buttons;
    Font labelFont = new Font("sansserif", 0, 12);
    CardLayout cardLayout;

    public DRadioButtons(String[] opts) {
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setOptions(opts, opts);
    }

    public void setTooltip(String s) {
        this.setToolTipText(s);
    }

    public void setOptions(String[] opts, String[] labs) {
        this.removeAll();
        if (opts == null) {
            opts = new String[]{};
        }
        this.options = opts;
        this.labels = labs;
        int nopt = opts.length;
        this.setLayout(new GridLayout(nopt, 1, 2, 2));
        ButtonGroup bgp = new ButtonGroup();
        this.buttons = new JRadioButton[nopt];
        int i = 0;
        while (i < nopt) {
            JRadioButton jrb = new JRadioButton(this.labels[i]);
            jrb.setActionCommand(this.options[i]);
            jrb.setFont(this.labelFont);
            bgp.add(jrb);
            this.buttons[i] = jrb;
            jrb.addActionListener(this);
            this.add(jrb);
            ++i;
        }
        this.revalidate();
    }

    public void setSelected(String s) {
        if (s == null) {
            int i = 0;
            while (i < this.options.length) {
                if (this.buttons[i].isSelected()) {
                    this.buttons[i].setSelected(false);
                }
                ++i;
            }
        } else {
            boolean done = false;
            int i = 0;
            while (i < this.options.length) {
                if (this.options[i].equals(s)) {
                    this.selected = s;
                    if (!this.buttons[i].isSelected()) {
                        this.buttons[i].setSelected(true);
                    }
                    done = true;
                }
                ++i;
            }
            if (!done) {
                E.error("cant set selected  - not an option " + s);
            }
        }
    }

    public String getSelected() {
        return this.selected;
    }

    public void actionPerformed(ActionEvent aev) {
        this.selected = aev.getActionCommand();
        this.deliverAction(this.selected, true);
    }

    public void setLabelActor(LabelActor bl) {
        this.lact = bl;
    }

    public void deliverAction(String s, boolean b) {
        if (this.lact != null) {
            this.lact.labelAction(s, b);
        }
    }

    public void setCardLayout() {
        this.cardLayout = new CardLayout();
        this.setLayout(this.cardLayout);
    }

    public void nextCard() {
        this.cardLayout.next(this);
    }

    public void showCard(String s) {
        this.cardLayout.show(this, s);
    }
}

