/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.druid.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import org.catacomb.druid.event.LabelActor;
import org.catacomb.druid.swing.DButton;
import org.catacomb.druid.swing.DCheckboxMenuItem;
import org.catacomb.druid.swing.DMenuItem;
import org.catacomb.druid.swing.Menued;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DPopLabel
extends JPanel
implements LabelActor {
    private static final String SHOW_MENU = "showMenu";
    static final long serialVersionUID = 1001L;
    int type = 0;
    boolean fixedSize = false;
    public static final int SIMPLE = 0;
    public static final int CHECKBOX = 1;
    JPopupMenu mymenu;
    DButton popB;
    String latestChoice;
    LabelActor ml;
    Menued menued;
    String[] options;

    public DPopLabel(String s) {
        this(s, s);
    }

    public DPopLabel(String s, String itxt) {
        this.popB = new DButton(itxt);
        this.popB.setActionCommand(SHOW_MENU);
        this.mymenu = new JPopupMenu();
        this.add(this.mymenu);
        this.popB.setLabelActor(this);
        this.setLayout(new BorderLayout());
        this.add("Center", this.popB);
    }

    public void setBg(Color c) {
        this.popB.setBg(c);
        this.setBackground(c);
    }

    public void clear() {
        this.mymenu.removeAll();
    }

    public void setLabel(String s) {
        this.popB.setText(s);
    }

    @Override
    public void setEnabled(boolean b) {
        this.popB.setEnabled(b);
        this.mymenu.setEnabled(b);
    }

    public void setLabelActor(LabelActor ml) {
        this.ml = ml;
    }

    public void setFixedSize(boolean b) {
        this.fixedSize = b;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.fixedSize) {
            return new Dimension(60, 20);
        }
        return this.popB.getPreferredSize();
    }

    public void setType(int ityp) {
        this.type = ityp;
    }

    public void setText(String s) {
        if (s == null) {
            s = "";
        }
        if (!s.equals(this.popB.getText())) {
            this.popB.setText(s);
            this.popB.invalidate();
            this.validate();
        }
    }

    public String getText() {
        return this.popB.getText();
    }

    public String getLabel() {
        return this.popB.getText();
    }

    public void myShowMenu() {
        String[] sa;
        if (this.menued != null && (sa = this.menued.getMenuOptions()) != null && sa != this.options) {
            this.setMenuOptions(sa);
        }
        this.checkNames();
        this.mymenu.show(this, 0, 25);
    }

    public void showMenu() {
        this.myShowMenu();
    }

    public void hideMenu() {
        this.mymenu.setVisible(false);
    }

    public void armSelection(String s) {
        Component[] cs = this.mymenu.getComponents();
        int i = 0;
        while (i < cs.length) {
            if (cs[i] instanceof DMenuItem) {
                DMenuItem cmi = (DMenuItem)cs[i];
                if (cmi.actionCommand.equals(s)) {
                    cmi.setArmed(true);
                } else {
                    cmi.setArmed(false);
                }
            }
            ++i;
        }
    }

    public void repaintMenu() {
        this.mymenu.repaint();
    }

    @Override
    public void labelAction(String sarg, boolean b) {
        if (sarg.equals(SHOW_MENU)) {
            this.myShowMenu();
        } else {
            this.deliverLabelAction(sarg, b);
        }
    }

    public void deliverLabelAction(String sarg, boolean b) {
        this.latestChoice = sarg;
        if (this.ml != null) {
            this.ml.labelAction(sarg, b);
        }
    }

    private int getItemCount() {
        return this.mymenu.getSubElements().length;
    }

    public void checkNames() {
        MenuElement[] jme = this.mymenu.getSubElements();
        int i = 0;
        while (i < jme.length) {
            MenuElement ob = jme[i];
            if (ob instanceof DMenuItem) {
                ((DMenuItem)ob).checkName();
            }
            ++i;
        }
    }

    public String[] getNames() {
        MenuElement[] jme = this.mymenu.getSubElements();
        String[] sa = new String[jme.length];
        int i = 0;
        while (i < jme.length) {
            MenuElement ob = jme[i];
            if (ob instanceof DMenuItem) {
                sa[i] = ((DMenuItem)this.mymenu.getComponent(i)).getText();
            }
            ++i;
        }
        return sa;
    }

    public boolean[] getStates() {
        MenuElement[] jme = this.mymenu.getSubElements();
        boolean[] ba = new boolean[jme.length];
        int i = 0;
        while (i < jme.length) {
            MenuElement mi = jme[i];
            ba[i] = false;
            if (mi instanceof DCheckboxMenuItem) {
                DCheckboxMenuItem tmi = (DCheckboxMenuItem)mi;
                ba[i] = tmi.getState();
            }
            ++i;
        }
        return ba;
    }

    public void setStates(String[] onm, boolean[] ob) {
        MenuElement[] jme = this.mymenu.getSubElements();
        int i = 0;
        while (i < jme.length) {
            MenuElement mi = jme[i];
            if (mi instanceof DCheckboxMenuItem) {
                DCheckboxMenuItem tmi = (DCheckboxMenuItem)mi;
                String s = tmi.getText();
                int k = 0;
                while (k < onm.length) {
                    if (s.equals(onm[k])) {
                        tmi.setState(ob[k]);
                    }
                    ++k;
                }
            }
            ++i;
        }
    }

    public void setState(String s, boolean b) {
        MenuElement[] jme = this.mymenu.getSubElements();
        int i = 0;
        while (i < jme.length) {
            DCheckboxMenuItem tmi;
            String sm;
            MenuElement mi = jme[i];
            if (mi instanceof DCheckboxMenuItem && (sm = (tmi = (DCheckboxMenuItem)mi).getText()).equals(s)) {
                tmi.setState(b);
            }
            ++i;
        }
    }

    public void addItem(String s) {
        this.addItem(s, false);
    }

    public void addItem(String s, boolean b) {
        if (this.type == 0) {
            DMenuItem tmi = new DMenuItem(s);
            this.mymenu.add(tmi);
        } else if (this.type == 1) {
            DCheckboxMenuItem tmi = new DCheckboxMenuItem(s, this, b);
            this.mymenu.add(tmi);
        }
    }

    public void addItems(String[] sa) {
        if (sa == null) {
            return;
        }
        int i = 0;
        while (i < sa.length) {
            this.addItem(sa[i]);
            ++i;
        }
    }

    public void addCheckboxItem(String s, boolean b) {
        DCheckboxMenuItem tmi = new DCheckboxMenuItem(s, this, b);
        tmi.setLabelActor(this);
        tmi.setActionCommand(s);
        this.mymenu.add(tmi);
    }

    public void addSeparator() {
        this.mymenu.addSeparator();
    }

    @Override
    public void removeAll() {
        this.options = null;
        this.mymenu.removeAll();
    }

    public void addHierarchical(String[] sa, boolean b) {
        if (sa == null) {
            return;
        }
        if (b) {
            sa = this.myStringSort(sa);
        }
        this.addHierarchical(sa);
    }

    public void addOptions(ArrayList<String> v) {
        String[] sa = new String[v.size()];
        int iin = 0;
        for (String s : v) {
            sa[iin++] = s;
        }
        this.addMenuOptions(sa);
    }

    public void addMenuOptions(String[] sa) {
        this.addHierarchical(sa);
    }

    public void setMenued(Menued md) {
        this.menued = md;
        this.setMenuOptions(this.menued.getMenuOptions());
    }

    public void setOptions(ArrayList<String> v) {
        this.setMenuOptions(v);
    }

    public void setMenuOptions(ArrayList<String> v) {
        String[] sa = new String[v.size()];
        int iin = 0;
        for (String s : v) {
            sa[iin++] = s;
        }
        this.setMenuOptions(sa);
    }

    public void setMenuOptions(String[] sa) {
        this.removeAll();
        this.options = sa;
        this.addHierarchical(sa);
    }

    public void addHierarchical(String[] sa) {
        this.growMenu(this.mymenu, "", sa, 0);
    }

    private int growMenu(Object tpm, String schop, String[] sa, int i0) {
        int nend = sa.length;
        int nchop = schop.length();
        int nn = 0;
        while (i0 + nn < nend && sa[i0 + nn] != null && sa[i0 + nn].startsWith(schop)) {
            String ss = sa[i0 + nn];
            String srest = ss.substring(nchop, ss.length());
            int inxt = srest.indexOf(":");
            if (inxt < 0) {
                inxt = srest.indexOf("/");
            }
            if (inxt > 1) {
                JMenu ttpm = new JMenu(srest.substring(0, inxt));
                if (tpm instanceof JPopupMenu) {
                    ((JPopupMenu)tpm).add(ttpm);
                }
                if (tpm instanceof JMenu) {
                    ((JMenu)tpm).add(ttpm);
                }
                nn += this.growMenu(ttpm, String.valueOf(schop) + srest.substring(0, inxt + 1), sa, i0 + nn);
                continue;
            }
            if (srest.equals("SEPARATOR")) {
                if (tpm instanceof JPopupMenu) {
                    ((JPopupMenu)tpm).addSeparator();
                } else if (tpm instanceof JMenu) {
                    ((JMenu)tpm).addSeparator();
                }
            } else {
                DMenuItem tmi = new DMenuItem(srest);
                tmi.setActionCommand(String.valueOf(schop) + srest);
                if (tpm instanceof JPopupMenu) {
                    ((JPopupMenu)tpm).add(tmi);
                }
                if (tpm instanceof JMenu) {
                    ((JMenu)tpm).add(tmi);
                }
            }
            ++nn;
        }
        return nn;
    }

    public void addAlphabeticizedSubsetted(String[] sa) {
        sa = this.myStringSort(sa);
        int nmin = 5;
        int nmax = 15;
        int ndone = 0;
        int ntot = sa.length;
        while (ndone < ntot) {
            int i;
            int nlet = 0;
            boolean ok = false;
            int lstcng = 0;
            while (!ok && nlet < 3) {
                lstcng = 0;
                String s0 = sa[ndone].substring(0, ++nlet);
                i = 0;
                while (i < nmax && ndone + i < ntot) {
                    String sn = sa[ndone + i].substring(0, nlet);
                    if (!sn.equals(s0)) {
                        lstcng = i - 1;
                        s0 = sn;
                    } else if (ndone + i == ntot - 1) {
                        lstcng = i;
                    }
                    ++i;
                }
                if (ndone + lstcng != ntot - 1 && lstcng < nmin) continue;
                ok = true;
            }
            if (!ok && ndone + (lstcng = nmax) >= ntot) {
                lstcng = ntot - ndone - 1;
            }
            String shead = String.valueOf(sa[ndone].substring(0, nlet)) + "-" + sa[ndone + lstcng].substring(0, nlet) + ":";
            i = 0;
            while (i <= lstcng) {
                sa[ndone + i] = String.valueOf(shead) + sa[ndone + i];
                ++i;
            }
            ndone += lstcng;
            ++ndone;
        }
        this.addHierarchical(sa);
    }

    private String[] myStringSort(String[] sa) {
        int n = sa.length;
        String[] ss = new String[n];
        int i = 0;
        while (i < n) {
            String sin = sa[i];
            int j = 0;
            while (j < i && ss[j].compareTo(sin) < 0) {
                ++j;
            }
            int k = i;
            while (k > j) {
                ss[k] = ss[k - 1];
                --k;
            }
            ss[j] = sin;
            ++i;
        }
        return ss;
    }
}

