/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.druid.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Point;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import javax.swing.plaf.ColorUIResource;
import org.catacomb.druid.swing.BorderUtil;
import org.catacomb.druid.swing.DMouseRelay;
import org.catacomb.interlish.interact.DComponent;
import org.catacomb.interlish.structure.MouseActor;
import org.catacomb.interlish.structure.MouseSource;
import org.catacomb.report.E;
import org.catacomb.util.ColorUtil;

public class DPanel
extends JPanel
implements DComponent,
MouseSource {
    static final long serialVersionUID = 1001L;
    private Border lineborder;
    private Font borderFont;
    private Color borderColor;
    public static final int PLAINFONT = 1;
    public static final int BOLDFONT = 2;

    public void setMouseActor(MouseActor ma) {
        this.addMouseListener(new DMouseRelay(ma));
    }

    public void setTooltip(String s) {
        this.setToolTipText(s);
    }

    public void setBg(Color c) {
        this.setBackground(c);
        if (c instanceof ColorUIResource) {
            E.warning("default UI bg color being applied - should be overridden: ");
            new Exception().printStackTrace();
        }
    }

    public void setFg(Color c) {
        this.setForeground(c);
        if (c instanceof ColorUIResource) {
            E.warning("default UI fg color being applied - should be overridden: ");
            new Exception().printStackTrace();
        }
    }

    public int[] getCenterLocationOnScreen() {
        Point p = this.getLocationOnScreen();
        Dimension d = this.getSize();
        int[] xy = new int[]{p.x + d.width / 2, p.y + d.height / 2};
        return xy;
    }

    public int[] getXYLocation() {
        return this.getCenterLocationOnScreen();
    }

    public void localSetBorder(Border b) {
        if (this.getBorder() instanceof TitledBorder) {
            E.error("replacing titled border with " + b);
        }
        super.setBorder(b);
    }

    public void setEtchedBorder(Color col) {
        this.localSetBorder(BorderUtil.makeEtchedBorder(col));
    }

    public void setEtchedUpBorder(Color col) {
        this.localSetBorder(BorderUtil.makeEtchedUpBorder(col));
    }

    public void addEtchedBorder(Color col) {
        Border bb = BorderUtil.makeEtchedBorder(col);
        this.addBorder(bb);
    }

    public void addSunkenBorder(Color col) {
        Color cbr = ColorUtil.brighter(col);
        Color cdk = ColorUtil.slightlyDarker(col);
        Border bb = BorderFactory.createBevelBorder(1, col, cbr, cdk, col);
        this.addBorder(bb);
    }

    public void clearBorder() {
        if (this.getBorder() != null) {
            this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        }
    }

    public void addBorder(int l, int r, int t, int b) {
        if (l == 0 && r == 0 && t == 0 && b == 0) {
            E.warning("DPanel add border called with zero width " + this);
        } else {
            Border border = BorderFactory.createEmptyBorder(t, l, b, r);
            this.addBorder(border);
        }
    }

    public void setEmptyBorder(int l, int r, int t, int b) {
        Border border = BorderFactory.createEmptyBorder(t, l, b, r);
        this.localSetBorder(border);
    }

    private void addBorder(Border bb) {
        Border bsf = this.getBorder();
        if (bsf == null) {
            this.localSetBorder(bb);
        } else {
            CompoundBorder cbd = new CompoundBorder(bb, bsf);
            this.localSetBorder(cbd);
        }
    }

    public void setSunkenBorder(Color col) {
        Color cbr = col.brighter();
        Color cdk = col.darker();
        this.localSetBorder(BorderFactory.createBevelBorder(1, col, cbr, cdk, col));
    }

    public void setFlowLayout() {
        this.setLayout(new FlowLayout(0, 0, 0));
    }

    public void setSingle() {
        this.setLayout(new GridLayout(1, 1, 0, 0));
    }

    public void addSingle(Object obj) {
        this.setSingle();
        this.add((JComponent)obj);
    }

    public void setFlowLeft(int h, int v) {
        this.setLayout(new FlowLayout(0, h, v));
    }

    public void setFlowRight(int h, int v) {
        this.setLayout(new FlowLayout(2, h, v));
    }

    public void setFlowCenter(int h, int v) {
        this.setLayout(new FlowLayout(1, h, v));
    }

    public void setBorderLayout() {
        this.setLayout(new BorderLayout(0, 0));
    }

    public void setBorderLayout(int h, int v) {
        this.setLayout(new BorderLayout(h, v));
    }

    public void addTitledBorder(String s) {
        if (this.lineborder == null) {
            this.lineborder = BorderFactory.createEmptyBorder(0, 0, 0, 0);
        }
        if (this.borderFont == null) {
            this.borderFont = new Font("sansserif", 1, 12);
            this.borderColor = new Color(90, 90, 90);
        }
        this.localSetBorder(BorderFactory.createTitledBorder(this.lineborder, s, 4, 2, this.borderFont, this.borderColor));
    }

    public void addTitledBorder(String s, int ifont, int txtcol, int linecol) {
        this.lineborder = BorderFactory.createLineBorder(new Color(linecol));
        Font f = null;
        f = ifont == 1 ? new Font("sansserif", 0, 12) : new Font("sansserif", 1, 12);
        Color tc = new Color(txtcol);
        TitledBorder b = BorderFactory.createTitledBorder(this.lineborder, s, 2, 2, f, tc);
        this.addBorder(b);
    }

    public void setPreferredSize(int w, int h) {
        this.setPreferredSize(new Dimension(w, h));
    }

    public int[] getXYLocationOnScreen() {
        int[] ixy = new int[]{400, 400};
        if (this.isShowing()) {
            Point p = this.getLocationOnScreen();
            ixy[0] = (int)p.getX();
            ixy[1] = (int)p.getY();
        }
        return ixy;
    }

    public void addDComponent(DComponent obj) {
        this.add((JComponent)((Object)obj));
    }

    public void addDComponent(DComponent obj, Object constraints) {
        this.add((Component)((JComponent)((Object)obj)), constraints);
    }

    public void removeDComponent(DComponent obj) {
        this.remove((JComponent)((Object)obj));
    }

    public void setGridLayout(int nr, int nc, int dx, int dy) {
        this.setLayout(new GridLayout(nr, nc, dx, dy));
    }
}

