/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.druid.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.io.StringReader;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.Document;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import org.catacomb.interlish.interact.DComponent;
import org.catacomb.interlish.structure.HyperlinkHandler;
import org.catacomb.interlish.structure.Page;
import org.catacomb.interlish.util.JUtil;
import org.catacomb.report.E;
import org.catacomb.xdoc.XdocBase;

public class DHTMLPane
extends JEditorPane
implements DComponent,
HyperlinkListener {
    static final long serialVersionUID = 1001L;
    HTMLEditorKit htmlEditorKit;
    StyleSheet styleSheet;
    static StyleSheet defaultStyleSheet;
    HyperlinkHandler hyperlinkHandler;

    public DHTMLPane() {
        this.setEditable(false);
        this.htmlEditorKit = new HTMLEditorKit();
        this.setEditorKit(this.htmlEditorKit);
    }

    public void setPrefSize(int w, int h) {
        this.setPreferredSize(new Dimension(w, h));
    }

    protected void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        super.paintComponent(g2);
    }

    public void setTooltip(String s) {
        this.setToolTipText(s);
    }

    public void setBg(Color c) {
        this.setBackground(c);
        this.colorizeAndApplyStylesheet();
    }

    public void setDefaultStyleSheet() {
        if (defaultStyleSheet == null) {
            defaultStyleSheet = this.loadRelStyleSheet(new XdocBase(), "defaultCSS.txt");
        }
        this.setStyleSheet(defaultStyleSheet);
    }

    public void setStylesheetPath(String s) {
        String[] sa = s.split(":");
        String scss = JUtil.getFileResource(sa[0], sa[1]);
        StyleSheet styles = new StyleSheet();
        try {
            styles.loadRules(new StringReader(scss), null);
        }
        catch (Exception ex) {
            E.error("" + ex);
        }
        this.setStyleSheet(styles);
    }

    public void setRelStyleSheet(Object rel, String fnm) {
        StyleSheet ss = this.loadRelStyleSheet(rel, fnm);
        this.setStyleSheet(ss);
    }

    public void clearHyperlinkListeners() {
        HyperlinkListener[] hyperlinkListenerArray = this.getHyperlinkListeners();
        int n = 0;
        int n2 = hyperlinkListenerArray.length;
        while (n < n2) {
            HyperlinkListener hl = hyperlinkListenerArray[n];
            this.removeHyperlinkListener(hl);
            ++n;
        }
    }

    public void setHyperlinkHandler(HyperlinkHandler lh) {
        this.hyperlinkHandler = lh;
        this.addHyperlinkListener(this);
    }

    private StyleSheet loadRelStyleSheet(Object ref, String fnm) {
        String scss = JUtil.getRelativeResource(ref, fnm);
        StyleSheet styles = new StyleSheet();
        try {
            styles.loadRules(new StringReader(scss), null);
        }
        catch (Exception ex) {
            E.error("" + ex);
        }
        return styles;
    }

    public void setStyleSheet(StyleSheet ss) {
        this.styleSheet = ss;
        this.colorizeAndApplyStylesheet();
    }

    public void colorizeAndApplyStylesheet() {
        if (this.styleSheet != null) {
            this.htmlEditorKit.setStyleSheet(this.styleSheet);
        }
    }

    public void showPage(Page page) {
        this.showHTML(page.getHTMLText());
    }

    public void showHTML(String s) {
        HTMLDocument doc = new HTMLDocument(this.styleSheet);
        try {
            this.htmlEditorKit.read(new StringReader(s), (Document)doc, 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setDocument(doc);
    }

    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            String s = e.getDescription();
            URL u = e.getURL();
            if (u != null) {
                this.hyperlinkHandler.hyperlinkClicked(u.toString());
            } else {
                this.hyperlinkHandler.hyperlinkClicked(s);
            }
        } else if (e.getEventType() != HyperlinkEvent.EventType.ENTERED) {
            e.getEventType();
        }
    }
}

