/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.druid.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JPanel;
import org.catacomb.druid.event.LabelActor;
import org.catacomb.druid.swing.DFloat;
import org.catacomb.druid.swing.DMouseRelay;
import org.catacomb.druid.swing.RolloverEffect;
import org.catacomb.interlish.structure.MouseActor;
import org.catacomb.interlish.structure.MouseSource;

public class DFloatSlider
extends JPanel
implements MouseSource,
MouseListener,
MouseMotionListener {
    static final long serialVersionUID = 1001L;
    DFloat dFloat;
    LabelActor labelActor;
    double value;
    int iscale;
    int state;
    static final int NONE = 0;
    static final int DRAG = 1;
    double linmin;
    double linmax;
    double linvalue;
    String label;
    int xslider;
    int xdown;
    int ydown;
    double linvaluedown;
    long downtime;
    Color bgColor;
    RolloverEffect rollover;

    public DFloatSlider(DFloat df, double v, double min, double max, int scl) {
        this.dFloat = df;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.attachRollover();
        this.setScale(scl);
        this.setRange(min, max);
        this.setValue(v);
    }

    public void setScale(int isc) {
        this.iscale = isc;
    }

    public void setRange(double min, double max) {
        if (this.isLog()) {
            this.linmin = this.mylog(min);
            this.linmax = this.mylog(max);
        } else {
            this.linmin = min;
            this.linmax = max;
        }
    }

    public void setMouseActor(MouseActor ma) {
        this.addMouseListener(new DMouseRelay(ma));
    }

    public void setLabel(String s) {
        this.label = s;
    }

    public void setBg(Color col) {
        this.setBackground(col);
        this.bgColor = col;
        this.rollover.setBg(col);
    }

    public boolean isLog() {
        return this.iscale == 1;
    }

    private double mylog(double v) {
        double xmin = 1.0E-99;
        if (v <= xmin) {
            v = xmin;
        }
        double ret = Math.log(v);
        return ret;
    }

    public void attachRollover() {
        this.rollover = new RolloverEffect(this);
        this.addMouseListener(this.rollover);
    }

    public void setLabelActor(LabelActor lact) {
        this.labelActor = lact;
    }

    private void notifyChange() {
        if (this.labelActor != null) {
            this.labelActor.labelAction("change", true);
        }
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double d) {
        this.value = d;
        this.linvalue = this.toLin(d);
        this.ensureInRange();
    }

    public double toLin(double d) {
        double ret = d;
        if (this.isLog()) {
            ret = this.mylog(this.value);
        }
        return ret;
    }

    public double fromLin(double d) {
        double ret = d;
        if (this.isLog()) {
            ret = Math.exp(d);
        }
        return ret;
    }

    public void export() {
        this.value = this.fromLin(this.linvalue);
        this.dFloat.setFromSlider(this.value);
    }

    private void ensureInRange() {
        if (this.linvalue < this.linmin) {
            this.linvalue = this.linmin;
        }
        if (this.linvalue > this.linmax) {
            this.linvalue = this.linmax;
        }
    }

    private void ensureRangeCovers() {
        if (this.linmin > this.linvalue) {
            this.linmin = this.linvalue;
        }
        if (this.linmax < this.linvalue) {
            this.linmax = this.linvalue;
        }
    }

    public Dimension getMinimumSize() {
        return new Dimension(80, 20);
    }

    public Dimension getPreferredSize() {
        return new Dimension(140, 22);
    }

    public void paintComponent(Graphics g) {
        this.realPaint(g);
    }

    public void realPaint(Graphics g) {
        int w = this.getWidth();
        int h = this.getHeight();
        if (this.bgColor == null) {
            this.bgColor = this.getBackground();
        }
        g.setColor(this.bgColor);
        g.fillRect(0, 0, w, h);
        this.paintArrows(g);
        this.paintKnob(g);
        if (this.label != null) {
            g.setColor(Color.black);
            g.drawString(this.label, 40, 20);
        }
    }

    private void paintArrows(Graphics g) {
        int w = this.getWidth();
        int h = this.getHeight();
        Color cbg = this.bgColor;
        Color cbr = cbg.brighter();
        Color cdk = cbg.darker();
        int hh = h / 2;
        g.setColor(cbr);
        g.drawLine(4, hh, 15, 4);
        g.drawLine(w - 15, h - 4, w - 15, 4);
        g.setColor(cdk);
        g.drawLine(15, 4, 15, h - 4);
        g.drawLine(4, hh, 15, h - 4);
        g.drawLine(w - 15, h - 4, w - 4, hh);
        g.drawLine(w - 15, 4, w - 4, hh);
    }

    private void paintKnob(Graphics g) {
        int width = this.getWidth();
        int height = this.getHeight();
        int hh = height / 2;
        double f = (this.linvalue - this.linmin) / (this.linmax - this.linmin);
        int icen = (int)(25.0 + f * (double)(width - 50));
        if (icen < 25) {
            icen = 25;
        }
        if (icen > width - 25) {
            icen = width - 25;
        }
        this.drawUpButton(g, icen, hh, 5, 5);
        this.xslider = icen;
    }

    private void drawUpButton(Graphics g, int icx, int icy, int hw, int hh) {
        Color c = this.getBackground();
        g.setColor(c.darker());
        g.drawLine(icx - hw - 1, icy + hh + 1, icx + hw + 1, icy + hh + 1);
        g.drawLine(icx - hw, icy + hh, icx + hw, icy + hh);
        g.drawLine(icx + hw + 1, icy - hh - 1, icx + hw + 1, icy + hh + 1);
        g.drawLine(icx + hw, icy - hh, icx + hw, icy + hh);
        g.setColor(c.brighter());
        g.drawLine(icx - hw - 1, icy - hh - 1, icx + hw + 1, icy - hh - 1);
        g.drawLine(icx - hw, icy - hh, icx + hw, icy - hh);
        g.drawLine(icx - hw - 1, icy - hh - 1, icx - hw - 1, icy + hh + 1);
        g.drawLine(icx - hw, icy - hh, icx - hw, icy + hh);
    }

    public void nudgeLeft() {
        this.nudge(-0.02);
    }

    public void nudgeRight() {
        this.nudge(0.02);
    }

    public void nudge(double f) {
        this.linvalue += f * (this.linmax - this.linmin);
        this.ensureInRange();
        this.export();
        this.repaint();
    }

    public void rsfMouseDown(int x, int y, long when, int button) {
        this.xdown = x;
        this.ydown = y;
        this.linvaluedown = this.linvalue;
        this.downtime = when;
        this.state = 0;
        if (x > 15 && x < this.getWidth() - 15) {
            this.state = 1;
        } else if (x < 15) {
            this.nudgeLeft();
        } else if (x > this.getWidth() - 15) {
            this.nudgeRight();
        }
    }

    public void rsfMouseUp(int x, int y) {
    }

    public void rsfMouseDrag(int x, int y) {
        int height = this.getHeight();
        int width = this.getWidth();
        double f = 0.0;
        if (y > height + 40) {
            f = 0.01 * (double)(height + 40 - y);
        } else if (y < -40) {
            f = 0.01 * (double)(40 + y);
        }
        if (this.state == 1) {
            double dr = Math.pow(10.0, f) * (double)(x - this.xdown) / (double)(width - 30);
            this.linvalue = this.linvaluedown + dr * (this.linmax - this.linmin);
            this.ensureInRange();
            this.export();
            this.repaint();
        }
    }

    public void mouseDragged(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        this.rsfMouseDrag(x, y);
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        long when = e.getWhen();
        int modif = e.getModifiers();
        int button = 0;
        if (modif == 16) {
            button = 1;
        } else if (modif == 8) {
            button = 2;
        } else if (modif == 4) {
            button = 3;
        }
        this.rsfMouseDown(x, y, when, button);
    }

    public void mouseReleased(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        this.rsfMouseUp(x, y);
    }

    public void mouseEntered(MouseEvent e) {
        this.requestFocus();
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
        this.requestFocus();
    }

    public double getTotalRange() {
        double ret = 1.0;
        ret = this.isLog() ? this.linmax - this.linmin : Math.pow(10.0, this.linmax) - Math.pow(10.0, this.linmin);
        return ret;
    }
}

