/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.druid.swing;

import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import org.catacomb.druid.swing.DBaseButton;
import org.catacomb.druid.swing.RolloverEffect;
import org.catacomb.interlish.structure.MouseSource;
import org.catacomb.report.E;

public class DButton
extends DBaseButton
implements ActionListener,
MouseSource {
    static final long serialVersionUID = 1001L;
    int rolloverOffStyle = 1;
    int rolloverOnStyle = 2;
    RolloverEffect rollover;

    public DButton(String lab) {
        if (lab != null && lab.length() > 0) {
            this.setText(lab);
        }
        this.label = lab;
        this.setFont(new Font("sansserif", 0, 12));
        this.addActionListener(this);
        this.setFocusPainted(false);
    }

    public void setTooltip(String s) {
        String swas = this.getToolTipText();
        if (swas != null) {
            E.warning("replacing tool tip " + swas + " with " + s + " ... ?");
        }
        this.setToolTipText(s);
    }

    public void setRolloverPolicy(int inorm, int ihover) {
        this.rolloverOffStyle = inorm;
        this.rolloverOnStyle = ihover;
    }

    public void applyRollover() {
        if (this.rollover != null) {
            this.removeMouseListener(this.rollover);
        }
        this.rollover = new RolloverEffect(this, this.rolloverOffStyle, this.rolloverOnStyle);
        this.addMouseListener(this.rollover);
    }

    public void setBg(Color c) {
        this.setBackground(c);
        if (this.rollover != null) {
            this.rollover.setBg(c);
        }
    }

    public void setFg(Color c) {
        this.setForeground(c);
    }

    public void actionPerformed(ActionEvent aev) {
        this.deliverAction(true);
    }

    public String toString() {
        return "DButton " + this.label;
    }

    public String getStringIdentifier() {
        return this.label;
    }

    public void setPadding(int p) {
        if (this.rollover == null) {
            this.applyRollover();
        }
        this.rollover.setPadding(p);
    }

    public void setPadding(int pl, int pr, int pt, int pb) {
        if (this.rollover == null) {
            this.applyRollover();
        }
        this.rollover.setPadding(pl, pr, pt, pb);
    }
}

