/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.druid.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.catacomb.druid.swing.CheckTreeSelectionModel;
import org.catacomb.druid.swing.TristateCheckBox;

public class CheckTreeRenderer
extends JPanel
implements TreeCellRenderer {
    private static final long serialVersionUID = 1L;
    private CheckTreeSelectionModel selectionModel;
    private TreeCellRenderer delegate;
    private TristateCheckBox checkBox = new TristateCheckBox();

    public CheckTreeRenderer(TreeCellRenderer delegate, CheckTreeSelectionModel selectionModel) {
        this.delegate = delegate;
        this.selectionModel = selectionModel;
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        this.checkBox.setOpaque(false);
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Component renderer = this.delegate.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        TreePath path = tree.getPathForRow(row);
        if (path != null) {
            if (this.selectionModel.isPathSelected(path, true)) {
                this.checkBox.setBooleanState(Boolean.TRUE);
            } else {
                this.checkBox.setBooleanState(this.selectionModel.isPartiallySelected(path) ? null : Boolean.FALSE);
            }
        }
        this.removeAll();
        this.add((Component)this.checkBox, "West");
        this.add(renderer, "Center");
        return this;
    }
}

