/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.druid.market;

import java.util.ArrayList;
import java.util.HashMap;
import org.catacomb.interlish.structure.Dependent;
import org.catacomb.interlish.structure.Supplier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SupplyClerk {
    String modality;
    HashMap<String, ArrayList<Dependent>> itemDependents;
    HashMap<String, Object> lastSupplied;

    public SupplyClerk(String s) {
        this.modality = s;
        this.itemDependents = new HashMap();
        this.lastSupplied = new HashMap();
    }

    public void notifyAllIfChanged(Supplier supplier) {
        for (String item : this.itemDependents.keySet()) {
            Object value;
            if (this.sameAsLast(item, value = supplier.get(this.modality, item))) continue;
            this.lastSupplied.put(item, value);
            this.sendTo(this.itemDependents.get(item), value);
        }
    }

    private boolean sameAsLast(String s, Object val) {
        Object oval;
        boolean ret = false;
        if (this.lastSupplied.containsKey(s) && (oval = this.lastSupplied.get(s)).equals(val)) {
            ret = true;
        }
        return ret;
    }

    private void sendTo(ArrayList<Dependent> arl, Object value) {
        for (Dependent dep : arl) {
            dep.newValue(value);
        }
    }

    public void addDependent(Dependent dep) {
        String s = dep.getInterestedIn();
        if (this.itemDependents.containsKey(s)) {
            this.itemDependents.get(s).add(dep);
        } else {
            ArrayList<Dependent> arl = new ArrayList<Dependent>();
            arl.add(dep);
            this.itemDependents.put(s, arl);
        }
    }
}

