/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.druid.market;

import java.util.HashMap;
import org.catacomb.druid.market.ProducerConsumerBoard;
import org.catacomb.interlish.structure.Consumer;
import org.catacomb.interlish.structure.Marketplace;
import org.catacomb.interlish.structure.Producer;
import org.catacomb.interlish.structure.Provider;
import org.catacomb.interlish.structure.Receiver;
import org.catacomb.interlish.structure.Supplier;
import org.catacomb.interlish.structure.Viewer;
import org.catacomb.interlish.structure.Visible;
import org.catacomb.interlish.util.JUtil;

public class HookupBoard
implements Marketplace {
    static HookupBoard globalBoard;
    static int nextBoardNo;
    String id;
    HashMap<String, ProducerConsumerBoard> boards = new HashMap();

    static {
        nextBoardNo = 0;
    }

    public HookupBoard() {
        this.id = "HB_" + ++nextBoardNo;
    }

    public String toString() {
        return "Mkt " + this.id;
    }

    public Marketplace global() {
        if (globalBoard == null) {
            globalBoard = new HookupBoard();
        }
        return globalBoard;
    }

    public void addProducer(String modality, Producer p, String flavor) {
        this.getPCBoard(modality).addProducer(p, flavor);
    }

    public void addConsumer(String modality, Consumer c, String flavor) {
        this.getPCBoard(modality).addConsumer(c, flavor);
    }

    public void addProvider(String modality, Provider p, String flavor) {
        this.getPCBoard(modality).addProvider(p, flavor);
    }

    public void addReceiver(String modality, Receiver rec, String flavor) {
        this.getPCBoard(modality).addReceiver(rec, flavor);
    }

    public void addSupplier(String modality, Supplier sup) {
        this.getPCBoard(modality).addSupplier(sup);
    }

    public void addVisible(String modality, Visible vbl, String flavor) {
        this.getPCBoard(modality).addVisible(vbl, flavor);
    }

    public void addViewer(String modality, Viewer vwr, String flavor) {
        this.getPCBoard(modality).addViewer(vwr, flavor);
    }

    private ProducerConsumerBoard getPCBoard(String modality) {
        ProducerConsumerBoard ret = null;
        if (this.boards.containsKey(modality)) {
            ret = this.boards.get(modality);
        } else {
            ret = this.makePCBoard(modality);
            this.boards.put(modality, ret);
        }
        return ret;
    }

    private ProducerConsumerBoard makePCBoard(String modality) {
        String scnm = "org.catacomb.druid.market." + modality + "Board";
        Object ret = JUtil.newInstance(scnm);
        ProducerConsumerBoard pcb = (ProducerConsumerBoard)ret;
        pcb.setModality(modality);
        return pcb;
    }

    public void logUnresolved() {
        if (this.boards != null) {
            for (ProducerConsumerBoard pcb : this.boards.values()) {
                pcb.logUnresolved(this.id);
            }
        }
    }
}

