/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.druid.load;

import java.io.File;
import org.catacomb.druid.load.Settings;
import org.catacomb.interlish.report.Logger;
import org.catacomb.interlish.report.PrintLogger;
import org.catacomb.interlish.service.AppPersist;
import org.catacomb.interlish.service.AppPersistProvider;
import org.catacomb.report.E;

public final class DruidAppBase
implements AppPersistProvider {
    static DruidAppBase instance;
    String applicationName;
    Logger logger;
    Settings settings;
    static String defaultApplicationName;

    static {
        defaultApplicationName = "druid-application";
    }

    public static void init() {
        DruidAppBase.init(null);
    }

    public static void init(String s) {
        String apn = null;
        apn = s == null || s.length() == 0 ? defaultApplicationName : s;
        if (instance == null) {
            instance = new DruidAppBase(apn);
            AppPersist.setProvider(instance);
        } else {
            E.debugError("Sys.init called when it has already been initialized");
        }
    }

    public DruidAppBase(String ap) {
        this.applicationName = ap;
    }

    public static DruidAppBase getSys() {
        if (instance == null) {
            DruidAppBase.init();
        }
        return instance;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public Settings getSettings() {
        if (this.settings == null) {
            this.settings = new Settings(this.applicationName);
        }
        return this.settings;
    }

    public Logger getLogger() {
        if (this.logger == null) {
            this.logger = new PrintLogger();
        }
        return this.logger;
    }

    public void requestExit() {
        System.exit(0);
    }

    public boolean hasValueFor(String pel) {
        return this.getSettings().hasElement(pel);
    }

    public boolean hasValue(String pel, String val) {
        return this.getSettings().hasElement(pel, val);
    }

    public String getValueFor(String pel) {
        return this.getSettings().getValue(pel);
    }

    public void addRecentFile(File f) {
        this.getSettings().addRecentFile(f);
    }

    public void setValue(String lab, String val) {
        this.getSettings().setElement(lab, val);
    }

    public String[] getRecentPaths() {
        return this.getSettings().getRecentPaths();
    }

    public void forceExit() {
        System.exit(0);
    }
}

