/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.druid.gui.edit;

import java.awt.Color;
import java.util.ArrayList;
import org.catacomb.druid.event.LabelActor;
import org.catacomb.druid.gui.base.DummyTree;
import org.catacomb.druid.gui.edit.DruChoice;
import org.catacomb.druid.gui.edit.DruGCPanel;
import org.catacomb.druid.gui.edit.DruMenu;
import org.catacomb.druid.swing.DScrollPane;
import org.catacomb.druid.swing.DTree;
import org.catacomb.druid.util.tree.RelationNode;
import org.catacomb.interlish.structure.PivotedTree;
import org.catacomb.interlish.structure.SelectionActor;
import org.catacomb.interlish.structure.SelectionSource;
import org.catacomb.interlish.structure.StringIdentifiable;
import org.catacomb.interlish.structure.Tree;
import org.catacomb.interlish.structure.TreeChangeReporter;
import org.catacomb.interlish.structure.TreeDisplay;
import org.catacomb.interlish.structure.TreeExplorer;
import org.catacomb.interlish.structure.TreeNode;
import org.catacomb.interlish.structure.TreeProvider;
import org.catacomb.report.E;

public class DruTreePanel
extends DruGCPanel
implements TreeDisplay,
TreeChangeReporter,
LabelActor,
SelectionActor,
TreeExplorer,
SelectionSource {
    static final long serialVersionUID = 1001L;
    DTree dTree = new DTree();
    DruChoice pivotChoice;
    DScrollPane scrollPane = new DScrollPane(this.dTree);
    Tree tree;
    SelectionActor selectionActor;
    boolean dropEvents;
    private TreeProvider treeProvider;
    private String selectionType;
    private String pathToOpen;
    private boolean pathRequired;
    private String lastSelection;
    private boolean defaultRootVisibility;

    public DruTreePanel() {
        this.setSingle();
        this.addDComponent(this.scrollPane);
        this.scrollPane.setScrollSize(180, 240);
        this.selectionType = "none";
        this.dTree.setSelectionActor(this);
        this.setTree(new DummyTree());
    }

    public void setRootVisibility(boolean b) {
        this.defaultRootVisibility = b;
    }

    public void setBg(Color c) {
        this.dTree.setBg(c);
        super.setBg(c);
    }

    public void clear() {
        this.tree = null;
        this.dTree.clear();
    }

    public void setTree(Tree tr) {
        if (tr != null) {
            int ipol;
            this.tree = tr;
            this.tree.setTreeChangeReporter(this);
            this.dTree.setTree(this.tree);
            if (this.pivotChoice != null && this.tree instanceof PivotedTree) {
                this.pivotChoice.setOptions(((PivotedTree)this.tree).getPivotNames());
            }
            if ((ipol = this.tree.getRootPolicy()) == 2) {
                this.dTree.setRootVisible(false);
            } else if (ipol == 1) {
                this.dTree.setRootVisible(true);
            } else {
                this.dTree.setRootVisible(this.defaultRootVisibility);
            }
        }
        if (this.pathToOpen != null) {
            this.ensureVisible(this.pathToOpen, this.pathRequired);
            this.pathToOpen = null;
        }
    }

    public void setPivotChoice(DruChoice pc) {
        this.pivotChoice = pc;
        E.missing("should action connect pivot choice");
        E.missing("cant add to toolbar...");
    }

    public void labelAction(String s, boolean b) {
        if (this.tree instanceof PivotedTree) {
            ((PivotedTree)this.tree).repivot(s);
            this.treeModified();
        }
    }

    public void setSelected(String s) {
        this.checkIsSelected(s);
    }

    public void selectionAction(Object osel, String sid) {
        if (osel == null) {
            return;
        }
        if (osel instanceof TreeNode) {
            this.selectionType = ((TreeNode)osel).isLeaf() ? "leaf" : "branch";
        } else {
            E.warning("non tree node in tree selection " + osel);
            this.selectionType = "none";
        }
        if (!this.dropEvents) {
            if (osel instanceof RelationNode) {
                RelationNode rnode = (RelationNode)osel;
                osel = rnode.getPeer();
            }
            if (this.selectionActor == null) {
                if (osel instanceof StringIdentifiable) {
                    sid = ((StringIdentifiable)osel).getStringIdentifier();
                } else if (osel instanceof TreeNode) {
                    sid = this.getSlashPath((TreeNode)osel);
                }
                this.lastSelection = sid;
                this.valueChange(sid);
            } else {
                this.selectionActor.selectionAction(osel, sid);
            }
        }
    }

    private String getSlashPath(TreeNode tn) {
        String ret = tn.toString();
        Object p = tn.getParent();
        if (p instanceof TreeNode) {
            ret = String.valueOf(this.getSlashPath((TreeNode)p)) + "/" + ret;
        }
        return ret;
    }

    public void setSelectionActor(SelectionActor sact) {
        this.selectionActor = sact;
    }

    public void treeModified() {
        this.dropEvents = true;
        this.dTree.setTree(this.tree);
        this.dropEvents = false;
    }

    public void showNewItem(Object[] pathToChild) {
        this.dropEvents = true;
        this.dTree.setTree(this.tree);
        this.dTree.dTreeExpandPath(pathToChild);
        this.dropEvents = false;
    }

    private void dumpptc(Object[] oa) {
        int i = 0;
        while (i < oa.length) {
            Object obj = oa[i];
            E.info("item " + i + "   " + obj + " " + obj.getClass().getName());
            ++i;
        }
    }

    public void setTreeProvider(TreeProvider provider) {
        this.treeProvider = provider;
        this.treeProvider.setTreeExplorer(this);
    }

    public void setMenu(DruMenu drum) {
        this.dTree.setMenu(drum.getGUIPeer());
    }

    public String getSelectionType() {
        return this.selectionType;
    }

    public void enableDrag() {
        this.dTree.enableDrag();
    }

    private Object[] pathTo(TreeNode tn) {
        ArrayList<Object> al = new ArrayList<Object>();
        al.add(tn);
        Object obj = tn.getParent();
        while (obj != null) {
            al.add(0, obj);
            obj = obj instanceof TreeNode ? ((TreeNode)obj).getParent() : null;
        }
        return al.toArray();
    }

    public void nodeAddedUnder(TreeNode parent, TreeNode child) {
        this.showNewItem(this.pathTo(parent));
    }

    public void nodeRemoved(TreeNode parent, TreeNode child) {
        this.showNewItem(this.pathTo(parent));
    }

    public void ensureVisible(String sfc) {
        this.ensureVisible(sfc, true);
    }

    public void ensureVisible(String sfc, boolean breq) {
        Object[] oa = this.tree.getObjectPath(sfc, breq);
        if (oa != null) {
            Object[] oap = new Object[oa.length - 1];
            int i = 0;
            while (i < oap.length) {
                oap[i] = oa[i];
                ++i;
            }
            this.dTree.dTreeExpandPath(oap);
        } else if (breq) {
            E.shortWarning("cant match " + sfc + " to a tree path in " + this.tree);
        }
    }

    public void setPathToOpen(String sfc) {
        this.setPathToOpen(sfc, true);
    }

    public void setPathToOpen(String sfc, boolean breq) {
        this.pathToOpen = sfc;
        this.pathRequired = breq;
    }

    public void checkIsSelected(String pth) {
        this.dropEvents = true;
        if (pth != null && !pth.equals(this.lastSelection)) {
            this.lastSelection = pth;
            Object[] oa = this.tree.getObjectPath(pth, true);
            if (oa == null) {
                E.warning("null object path for " + pth);
            } else {
                this.dTree.setSelected(oa);
            }
        }
        this.dropEvents = false;
    }

    public String getSelection() {
        return this.lastSelection;
    }
}

