/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.druid.gui.base;

import java.util.ArrayList;
import java.util.HashMap;
import org.catacomb.druid.gui.base.DruActionRelay;
import org.catacomb.druid.gui.base.DruPanel;
import org.catacomb.interlish.content.StringValue;
import org.catacomb.interlish.structure.ActionSource;
import org.catacomb.interlish.structure.StringValueEditor;
import org.catacomb.interlish.structure.TextSettable;
import org.catacomb.report.E;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PanelPack {
    DruPanel mainPanel;
    HashMap<String, Object> components;
    ArrayList<Object> anonCpts;

    public PanelPack(DruPanel dp, ArrayList<Object> anons, HashMap<String, Object> hm) {
        this.mainPanel = dp;
        this.anonCpts = anons;
        this.components = hm;
    }

    public DruPanel getMainPanel() {
        return this.mainPanel;
    }

    public boolean hasComponent(String sid) {
        return this.components.containsKey(sid);
    }

    public Object getComponent(String sid) {
        Object ret = null;
        if (this.components.containsKey(sid)) {
            ret = this.components.get(sid);
        } else {
            E.error("no such component in panel pack " + sid);
            for (String s : this.components.keySet()) {
                E.info("known cpt " + s);
            }
        }
        return ret;
    }

    public void setText(String cpt, String txt) {
        if (this.hasComponent(cpt)) {
            Object obj = this.getComponent(cpt);
            if (obj instanceof TextSettable) {
                ((TextSettable)obj).setText(txt);
            } else {
                E.error("cant set text in " + obj);
            }
        } else {
            E.error("no such cpt in panel pack " + cpt);
            this.reportComponents();
        }
    }

    public void actionConnect(Object tgt) {
        DruActionRelay dar = new DruActionRelay(tgt);
        for (Object obj : this.anonCpts) {
            this.connectRelay(dar, obj);
        }
        for (Object obj : this.components.values()) {
            this.connectRelay(dar, obj);
        }
    }

    private void connectRelay(DruActionRelay dar, Object obj) {
        if (obj instanceof ActionSource) {
            ((ActionSource)obj).setActionRelay(dar);
        }
    }

    public void reportComponents() {
        int icpt = 0;
        for (String s : this.components.keySet()) {
            E.info("known cpt " + icpt + " " + s);
            ++icpt;
        }
    }

    public void setStringValue(String cpt, StringValue sv) {
        if (this.hasComponent(cpt)) {
            Object obj = this.getComponent(cpt);
            if (obj instanceof StringValueEditor) {
                ((StringValueEditor)obj).setStringValue(sv);
            } else {
                E.error("cant set text in " + obj);
            }
        } else {
            E.error("no such cpt in panel pack " + cpt);
            this.reportComponents();
        }
    }
}

