/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.druid.gui.base;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import org.catacomb.druid.gui.base.DruLabel;
import org.catacomb.druid.gui.edit.DruMenu;
import org.catacomb.druid.swing.DPanel;
import org.catacomb.druid.swing.DScrollablePanel;
import org.catacomb.interlish.interact.DComponent;
import org.catacomb.interlish.structure.InfoReceiver;
import org.catacomb.interlish.structure.MouseActor;
import org.catacomb.report.E;

public class DruPanel
implements MouseActor {
    static final long serialVersionUID = 1001L;
    public static final int SCROLLABLE = 1;
    String id;
    String title;
    String tip;
    String info;
    DPanel dPanel;
    public InfoReceiver infoReceiver;
    Color bgColor;
    Color fgColor;
    DComponent tooltipTarget;

    public DruPanel() {
        this.dPanel = new DPanel();
        this.id = "";
    }

    public DruPanel(int props) {
        this.dPanel = props == 1 ? new DScrollablePanel() : new DPanel();
        this.id = "";
    }

    public void setTooltipTarget(DComponent dc) {
        this.tooltipTarget = dc;
    }

    public DPanel getGUIPeer() {
        return this.dPanel;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + " id=" + this.id;
    }

    public void setID(String s) {
        this.id = s;
    }

    public String getID() {
        return this.id;
    }

    public void setTitleInfo(String st, String si) {
        this.title = st;
        this.info = si;
    }

    public void setTitle(String s) {
        if (this.title != null) {
            E.warning("overwriting title " + this.title + " with " + s);
        }
        this.title = s;
    }

    public void setTip(String s) {
        this.tip = s;
        if (this.tip != null && this.tip.length() > 3) {
            if (this.tooltipTarget != null) {
                this.tooltipTarget.setTooltip(this.tip);
            } else {
                E.shortWarning("no target for tooltip " + s + " " + this);
            }
        }
    }

    public String getTip() {
        return this.tip;
    }

    public String getTitle() {
        return this.title;
    }

    public void setInfo(String s) {
        this.info = s;
    }

    public String getInfo() {
        return this.info;
    }

    public void setInfoReceiver(InfoReceiver ir) {
        this.infoReceiver = ir;
    }

    public InfoReceiver getInfoReceiver() {
        return this.infoReceiver;
    }

    public void mouseButtonPressed() {
        this.exportInfo();
    }

    public void exportInfo() {
        if (this.infoReceiver != null) {
            if (this.getInfo() != null && this.getInfo().length() > 0) {
                if (this.getTitle() == null || this.getTitle().startsWith("Panel")) {
                    E.shortWarning("no title for panel exporting info " + this);
                }
                this.infoReceiver.receiveInfo(this.getTitle(), this.getInfo());
            }
        } else {
            E.warning("no info receiver on " + this);
            new Exception().printStackTrace();
        }
    }

    public void setBg(Color c) {
        this.bgColor = c;
        this.dPanel.setBg(c);
    }

    public void setFg(Color c) {
        this.fgColor = c;
        this.dPanel.setFg(c);
    }

    public Color getBg() {
        return this.bgColor;
    }

    public void setColors(DruPanel dp) {
        dp.setFallbackBackgroundColor(this.bgColor);
        dp.setFallbackForegroundColor(this.fgColor);
    }

    public void setColors(DruLabel dp) {
        dp.setBg(this.bgColor);
        dp.setFg(this.fgColor);
    }

    public void addPanel(DruPanel drup) {
        this.setColors(drup);
        this.dPanel.add(drup.getGUIPeer());
    }

    public void addMenu(DruMenu menu) {
        menu.setBg(this.bgColor);
        menu.setFg(this.fgColor);
        this.dPanel.add(menu.getGUIPeer());
    }

    public void addCardPanel(DruPanel drup) {
        this.setColors(drup);
        this.dPanel.add((Component)drup.getGUIPeer(), drup.getTitle());
    }

    public void addPanel(DruPanel drup, Object constraints) {
        this.dPanel.add((Component)drup.getGUIPeer(), constraints);
    }

    public void addDComponent(DComponent obj) {
        this.dPanel.addDComponent(obj);
    }

    public void addSingleDComponent(DComponent obj) {
        this.setSingle();
        this.dPanel.addDComponent(obj);
        if (this.tip != null && this.tip.length() > 3) {
            obj.setTooltip(this.tip);
        }
        this.tooltipTarget = obj;
    }

    public void addDComponent(DComponent cpt, Object constraints) {
        this.dPanel.addDComponent(cpt, constraints);
    }

    public void removeDComponent(DComponent cpt) {
        this.dPanel.removeDComponent(cpt);
    }

    public void removeAll() {
        this.dPanel.removeAll();
    }

    public void removePanel(DruPanel dp) {
        this.dPanel.remove(dp.getGUIPeer());
    }

    public void postApply() {
    }

    public void setSingle() {
        this.dPanel.setSingle();
    }

    public void revalidate() {
        this.dPanel.revalidate();
    }

    public void validate() {
        this.dPanel.validate();
    }

    public void repaint() {
        this.dPanel.repaint();
    }

    public void addBorder(int i, int j, int k, int l) {
        this.dPanel.addBorder(i, j, k, l);
    }

    public void setEmptyBorder(int i, int j, int k, int l) {
        this.dPanel.setEmptyBorder(i, j, k, l);
    }

    public void setPreferredSize(int prefWidth, int prefHeight) {
        this.dPanel.setPreferredSize(prefWidth, prefHeight);
    }

    public void addEtchedBorder(Color bg) {
        this.dPanel.addEtchedBorder(bg);
    }

    public void addTitledBorder(String borderTitle) {
        this.dPanel.addTitledBorder(borderTitle);
    }

    public void setEtchedBorder(Color bg) {
        this.dPanel.setEtchedBorder(bg);
    }

    public void setSunkenBorder(Color bg) {
        this.dPanel.setSunkenBorder(bg);
    }

    public void addSunkenBorder(Color bg) {
        this.dPanel.addSunkenBorder(bg);
    }

    public void setBorderLayout(int xspace, int yspace) {
        this.dPanel.setBorderLayout(xspace, yspace);
    }

    public Dimension getPreferredSize() {
        return this.dPanel.getPreferredSize();
    }

    public void setFlowLayout() {
        this.dPanel.setFlowLayout();
    }

    public void setGridLayout(int nr, int nc, int dx, int dy) {
        this.dPanel.setGridLayout(nr, nc, dx, dy);
    }

    public void setFlowLeft(int dx, int dy) {
        this.dPanel.setFlowLeft(dx, dy);
    }

    public void setFlowRight(int dx, int dy) {
        this.dPanel.setFlowRight(dx, dy);
    }

    public void setFlowCenter(int dx, int dy) {
        this.dPanel.setFlowCenter(dx, dy);
    }

    public void setEtchedUpBorder(Color c) {
        this.dPanel.setEtchedUpBorder(c);
    }

    public void setPreferredSize(Dimension d) {
        this.dPanel.setPreferredSize(d);
    }

    public int[] getXYLocationOnScreen() {
        return this.dPanel.getXYLocationOnScreen();
    }

    public void setBackgroundColor(Color color) {
        this.bgColor = color;
        this.setBg(this.bgColor);
    }

    public void setFallbackBackgroundColor(Color bg) {
        if (this.bgColor == null) {
            this.bgColor = bg;
            this.setBg(bg);
        }
    }

    public void seForegroundColor(Color color) {
        this.fgColor = color;
        this.setFg(this.fgColor);
    }

    public void setFallbackForegroundColor(Color fg) {
        if (this.fgColor == null) {
            this.fgColor = fg;
            this.setFg(fg);
        }
    }
}

