/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.druid.build;

import java.util.HashMap;
import java.util.Map;
import org.catacomb.druid.gui.base.DruAssemblyPanel;
import org.catacomb.druid.market.HookupBoard;
import org.catacomb.interlish.report.PrintProgressReport;
import org.catacomb.interlish.structure.AssemblyEditor;
import org.catacomb.interlish.structure.Button;
import org.catacomb.interlish.structure.Choice;
import org.catacomb.interlish.structure.ColorValueEditor;
import org.catacomb.interlish.structure.Dialog;
import org.catacomb.interlish.structure.DoubleValueEditor;
import org.catacomb.interlish.structure.InfoReceiver;
import org.catacomb.interlish.structure.IntegerValueEditor;
import org.catacomb.interlish.structure.Marketplace;
import org.catacomb.interlish.structure.ObjectValueSettable;
import org.catacomb.interlish.structure.PopulableMenu;
import org.catacomb.interlish.structure.ProgressReport;
import org.catacomb.interlish.structure.SaverLoader;
import org.catacomb.interlish.structure.StringValueEditor;
import org.catacomb.interlish.structure.StringValueSettable;
import org.catacomb.interlish.structure.TargetStore;
import org.catacomb.interlish.structure.TextArea;
import org.catacomb.interlish.structure.TextField;
import org.catacomb.interlish.structure.Toggle;
import org.catacomb.report.E;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DruidTargetStore
implements TargetStore {
    HashMap<String, Object> hashMap = new HashMap();
    HashMap<String, Object> shortHM = new HashMap();
    private HookupBoard hookupBoard;
    InfoReceiver infoReceiver;

    HashMap<String, Object> getHashMap() {
        return this.hashMap;
    }

    public HashMap<String, Object> getIdentifiedComponentMap() {
        return this.hashMap;
    }

    @Override
    public SaverLoader getModel() {
        return null;
    }

    public void addComponent(String id, Object cpt) {
        if (this.hashMap.containsKey(id)) {
            E.warning("duplicate target ids: " + id + " " + this.hashMap.get(id) + "  and " + cpt);
        }
        this.hashMap.put(id, cpt);
        String ss = id.substring(id.lastIndexOf(".") + 1, id.length());
        if (this.shortHM.containsKey(ss)) {
            E.warning("duplicates in shortHM " + ss + " must use full path");
        } else {
            this.shortHM.put(ss, cpt);
        }
    }

    private Object quietGet(String id) {
        Object ret = null;
        if (id.indexOf(".") < 0) {
            ret = this.shortHM.get(id);
        } else if (id.startsWith("*")) {
            ret = this.wildcardGet(id);
        } else if (this.hashMap.containsKey(id)) {
            ret = this.hashMap.get(id);
        }
        return ret;
    }

    @Override
    public Object get(String id) {
        Object ret = this.quietGet(id);
        return ret;
    }

    @Override
    public void printAvailable() {
        if (this.hashMap == null || this.hashMap.size() == 0) {
            E.info("there are no entries in the target store");
        } else {
            for (Map.Entry<String, Object> ment : this.hashMap.entrySet()) {
                E.info("known item : " + ment.getKey() + " " + ment.getValue());
            }
        }
    }

    @Override
    public boolean has(String id) {
        Object obj = this.quietGet(id);
        return obj != null;
    }

    private Object wildcardGet(String s) {
        Object ret = null;
        if (s.startsWith("*.")) {
            ret = this.quietGet(s.substring(2, s.length()));
        }
        if (ret == null) {
            String sm = s.substring(1, s.length());
            String fm = null;
            for (String key : this.hashMap.keySet()) {
                if (!key.endsWith(sm)) continue;
                if (fm == null) {
                    fm = key;
                    ret = this.hashMap.get(key);
                    continue;
                }
                E.error("multiple items match wildcard " + s);
                E.info("first=" + fm);
                E.info("also: " + key);
            }
        }
        return ret;
    }

    @Override
    public void setStringValue(String id, String value) {
        Object obj = this.get(id);
        if (obj instanceof StringValueSettable) {
            ((StringValueSettable)obj).setStringValue(value);
        } else {
            E.error("cant set " + value + " in " + id);
        }
    }

    @Override
    public void setObjectValue(String id, Object val) {
        Object obj = this.get(id);
        if (obj instanceof ObjectValueSettable) {
            ((ObjectValueSettable)obj).setObjectValue(val);
        } else {
            E.error("cant set " + val + " in " + id);
        }
    }

    @Override
    public ProgressReport getProgressReport(String id) {
        ProgressReport ret = null;
        Object obj = this.get(id);
        if (obj != null && obj instanceof ProgressReport) {
            ret = (ProgressReport)obj;
        } else {
            E.error("cant get progress report " + id + " (got " + obj + ")");
            ret = new PrintProgressReport();
        }
        return ret;
    }

    @Override
    public PopulableMenu getSubMenu(String id) {
        Object obj = this.get(id);
        PopulableMenu ret = null;
        if (obj instanceof PopulableMenu) {
            ret = (PopulableMenu)obj;
        } else {
            E.error("cant get subMenu " + id + " (got " + obj + ")");
        }
        return ret;
    }

    @Override
    public Button getButton(String id) {
        Object obj = this.get(id);
        Button ret = null;
        if (obj instanceof Button) {
            ret = (Button)obj;
        } else {
            E.error("cant get button " + id + " (got " + obj + ")");
        }
        return ret;
    }

    @Override
    public AssemblyEditor getAssemblyEditor() {
        DruAssemblyPanel ret = null;
        for (Object obj : this.hashMap.values()) {
            if (!(obj instanceof DruAssemblyPanel)) continue;
            ret = (DruAssemblyPanel)obj;
            break;
        }
        if (ret == null) {
            E.error("no assembly panel in target store");
        }
        return ret;
    }

    public void setHookupBoard(HookupBoard hb) {
        this.hookupBoard = hb;
        hb.addVisible("TargetStore", this, "access");
    }

    @Override
    public Marketplace getMarketplace() {
        return this.hookupBoard;
    }

    public HookupBoard getHoookupBoard() {
        return this.hookupBoard;
    }

    public void clear() {
        this.hashMap.clear();
    }

    @Override
    public Dialog getDialog(String s) {
        Object obj = this.get(s);
        Dialog ret = null;
        if (obj instanceof Dialog) {
            ret = (Dialog)obj;
        } else {
            E.error("wrong type " + s);
        }
        return ret;
    }

    @Override
    public TextField getTextField(String s) {
        Object obj = this.get(s);
        TextField ret = null;
        if (obj instanceof TextField) {
            ret = (TextField)obj;
        } else {
            E.error("wrong type " + s);
        }
        return ret;
    }

    @Override
    public TextArea getTextArea(String s) {
        Object obj = this.get(s);
        TextArea ret = null;
        if (obj instanceof TextArea) {
            ret = (TextArea)obj;
        } else {
            E.error("wrong type " + s);
        }
        return ret;
    }

    @Override
    public Choice getChoice(String s) {
        Object obj = this.get(s);
        Choice ret = null;
        if (obj instanceof Choice) {
            ret = (Choice)obj;
        } else {
            E.error("wrong type " + s);
        }
        return ret;
    }

    @Override
    public Toggle getToggle(String s) {
        Object obj = this.get(s);
        Toggle ret = null;
        if (obj instanceof Toggle) {
            ret = (Toggle)obj;
        } else {
            E.error("wrong type " + s);
        }
        return ret;
    }

    public void setInfoReceiver(InfoReceiver ir) {
        this.infoReceiver = ir;
    }

    @Override
    public InfoReceiver getInfoReceiver() {
        return this.infoReceiver;
    }

    @Override
    public StringValueEditor getStringValueEditor(String sid) {
        Object obj = this.get(sid);
        StringValueEditor ret = null;
        if (obj instanceof StringValueEditor) {
            ret = (StringValueEditor)obj;
        } else {
            E.error("wrong type item " + sid + " - " + obj);
        }
        return ret;
    }

    @Override
    public IntegerValueEditor getIntegerValueEditor(String sid) {
        Object obj = this.get(sid);
        IntegerValueEditor ret = null;
        if (obj instanceof IntegerValueEditor) {
            ret = (IntegerValueEditor)obj;
        } else {
            E.error("wrong type item " + sid + " - " + obj);
        }
        return ret;
    }

    @Override
    public DoubleValueEditor getDoubleValueEditor(String sid) {
        Object obj = this.get(sid);
        DoubleValueEditor ret = null;
        if (obj instanceof DoubleValueEditor) {
            ret = (DoubleValueEditor)obj;
        } else {
            E.error("wrong type item " + sid + " - " + obj);
        }
        return ret;
    }

    @Override
    public ColorValueEditor getColorValueEditor(String sid) {
        Object obj = this.get(sid);
        ColorValueEditor ret = null;
        if (obj instanceof ColorValueEditor) {
            ret = (ColorValueEditor)obj;
        } else {
            E.error("wrong type item " + sid + " - " + obj);
        }
        return ret;
    }
}

