/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.druid.build;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import org.catacomb.druid.build.Druid;
import org.catacomb.interlish.annotation.ControlPoint;
import org.catacomb.interlish.annotation.Editable;
import org.catacomb.interlish.annotation.IOPoint;
import org.catacomb.interlish.content.BooleanValue;
import org.catacomb.interlish.content.ColorValue;
import org.catacomb.interlish.content.DoubleValue;
import org.catacomb.interlish.content.IntegerValue;
import org.catacomb.interlish.content.StringValue;
import org.catacomb.interlish.structure.BooleanValueEditor;
import org.catacomb.interlish.structure.ColorValueEditor;
import org.catacomb.interlish.structure.Controller;
import org.catacomb.interlish.structure.DoubleValueEditor;
import org.catacomb.interlish.structure.IntegerValueEditor;
import org.catacomb.interlish.structure.StringValueEditor;
import org.catacomb.interlish.structure.TargetStore;
import org.catacomb.report.E;

public class AnnotationConnector {
    TargetStore targetStore;

    public AnnotationConnector(TargetStore tgs) {
        this.targetStore = tgs;
    }

    public void annotationConnect(Object ctrl) {
        int nanot = 0;
        Field[] fieldArray = ctrl.getClass().getFields();
        int n = 0;
        int n2 = fieldArray.length;
        while (n < n2) {
            Field fld = fieldArray[n];
            Annotation[] aa = fld.getDeclaredAnnotations();
            if (aa != null && aa.length > 0) {
                nanot += aa.length;
                Annotation[] annotationArray = aa;
                int n3 = 0;
                int n4 = annotationArray.length;
                while (n3 < n4) {
                    Annotation ant = annotationArray[n3];
                    if (ant instanceof IOPoint) {
                        this.ioPointConnect(ctrl, fld, ((IOPoint)ant).xid());
                    } else if (ant instanceof Editable) {
                        this.editableConnect(ctrl, fld, ((Editable)ant).xid());
                    } else if (ant instanceof ControlPoint) {
                        this.controlConnect(ctrl, fld, ((ControlPoint)ant).xid());
                    } else {
                        E.warning("unhandled annotation " + ant);
                    }
                    ++n3;
                }
            }
            ++n;
        }
        int nta = 0;
        Field[] fieldArray2 = ctrl.getClass().getDeclaredFields();
        n2 = 0;
        int n5 = fieldArray2.length;
        while (n2 < n5) {
            Field fld = fieldArray2[n2];
            Annotation[] aa = fld.getDeclaredAnnotations();
            if (aa != null) {
                nta += aa.length;
            }
            ++n2;
        }
        if (nta > nanot) {
            E.shortError("Class " + ctrl.getClass() + " has unused annotations\n " + "(anotatiosn of private fields) - shoud these be public fields?");
        }
    }

    private void editableConnect(Object ctrl, Field fld, String guiID) {
        Object fval = null;
        try {
            fval = fld.get(ctrl);
        }
        catch (Exception ex) {
            E.warning("cant get field " + fld + " on " + ctrl);
        }
        if (fval == null) {
            E.warning("all editable fields should be set in the constructor - not so for " + fld.getName() + " on " + ctrl);
        } else {
            Object cpt = this.targetStore.get(guiID);
            if (cpt == null) {
                E.error("No such cpt in target store : " + guiID);
            } else {
                this.setEditable(fval, cpt);
            }
        }
    }

    private void setEditable(Object fval, Object edtr) {
        if (fval instanceof StringValue && edtr instanceof StringValueEditor) {
            ((StringValueEditor)edtr).setStringValue((StringValue)fval);
        } else if (fval instanceof BooleanValue && edtr instanceof BooleanValueEditor) {
            ((BooleanValueEditor)edtr).setBooleanValue((BooleanValue)fval);
        } else if (fval instanceof IntegerValue && edtr instanceof IntegerValueEditor) {
            ((IntegerValueEditor)edtr).setIntegerValue((IntegerValue)fval);
        } else if (fval instanceof DoubleValue && edtr instanceof DoubleValueEditor) {
            ((DoubleValueEditor)edtr).setDoubleValue((DoubleValue)fval);
        } else if (fval instanceof ColorValue && edtr instanceof ColorValueEditor) {
            ((ColorValueEditor)edtr).setColorValue((ColorValue)fval);
        } else {
            E.error("cant connect val to editor " + fval + " " + edtr);
        }
    }

    private void controlConnect(Object ctrl, Field fld, String guiID) {
        Object cpt = this.targetStore.get(guiID);
        if (cpt == null) {
            E.linkToWarning("No such cpt in target store : " + guiID + " when connecting " + "controller ", ctrl);
            this.targetStore.printAvailable();
        } else {
            Object subctrl = null;
            if (cpt instanceof Druid) {
                subctrl = ((Druid)cpt).getController();
            } else if (cpt instanceof Controller) {
                subctrl = cpt;
            } else {
                E.error("cant control connect " + cpt + " " + cpt.getClass().getName());
            }
            if (subctrl != null) {
                try {
                    fld.set(ctrl, subctrl);
                }
                catch (Exception ex) {
                    E.error("cant set gui cpt in controller: " + guiID + " cpt is " + cpt + " but field needs " + fld.getType());
                }
            }
        }
    }

    private void ioPointConnect(Object ctrl, Field fld, String guiID) {
        Object cpt = this.targetStore.get(guiID);
        if (cpt == null) {
            E.linkToWarning("No such cpt in target store : " + guiID + " when connecting " + "controller ", ctrl);
            this.targetStore.printAvailable();
        } else {
            try {
                fld.set(ctrl, cpt);
            }
            catch (Exception ex) {
                E.error("cant set gui cpt in controller: " + guiID + " cpt is " + cpt + " but field needs " + fld.getType());
            }
        }
    }
}

