/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.dataview.gui;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import org.catacomb.dataview.display.ViewConfig;
import org.catacomb.dataview.formats.DataHandler;
import org.catacomb.dataview.formats.PolyLineHandler;
import org.catacomb.dataview.gui.DViewPlotController;
import org.catacomb.dataview.model.LineGraph;
import org.catacomb.dataview.model.Plottable;
import org.catacomb.dataview.model.View;
import org.catacomb.druid.dialog.Dialoguer;
import org.catacomb.druid.gui.edit.DruMenu;
import org.catacomb.druid.load.DruidResourceLoader;
import org.catacomb.interlish.annotation.ControlPoint;
import org.catacomb.interlish.annotation.IOPoint;
import org.catacomb.interlish.reflect.ReflectionConstructor;
import org.catacomb.interlish.service.ResourceAccess;
import org.catacomb.interlish.structure.Controller;
import org.catacomb.report.E;
import org.catacomb.serial.Deserializer;
import org.catacomb.util.FileUtil;

public class DViewController
implements Controller {
    @IOPoint(xid="ViewMenu")
    public DruMenu viewMenu;
    @ControlPoint(xid="plotController")
    public DViewPlotController basicController;
    private DataHandler dataHandler;
    ArrayList<ViewConfig> viewConfigs;

    public void open() {
        File f = Dialoguer.getFile("CCViz");
        if (f != null) {
            this.open(f);
        }
    }

    public void open(File f) {
        if (f.isDirectory()) {
            f = this.findConfig(f);
        }
        DruidResourceLoader drl = new DruidResourceLoader();
        drl.addPath("org.catacomb.dataview.model");
        ResourceAccess.setResourceLoader(drl);
        ReflectionConstructor.addPath("org.catacomb.dataview.model");
        String s = FileUtil.readStringFromFile(f);
        Object obj = Deserializer.deserialize(s);
        if (obj instanceof LineGraph) {
            LineGraph lineGraph = (LineGraph)obj;
            PolyLineHandler plh = new PolyLineHandler();
            this.dataHandler = plh;
            for (Plottable pl : lineGraph.getPlottables()) {
                plh.addItems(pl.getDisplayables(f.getParentFile()));
            }
            plh.setXAxis(lineGraph.getXAxis());
            plh.setYAxis(lineGraph.getYAxis());
            this.viewConfigs = new ArrayList();
            for (View v : lineGraph.getViews()) {
                ViewConfig vc = new ViewConfig(v.getID(), v.getXYXY());
                this.viewConfigs.add(vc);
                plh.addView(vc);
            }
            int w = lineGraph.getWidth();
            int h = lineGraph.getHeight();
            if (w > 99 && h > 99) {
                this.basicController.setViewSize(w, h);
            }
            this.basicController.setDataHandler(plh);
        }
    }

    private File findConfig(File fdir) {
        File ret = null;
        File[] fileArray = fdir.listFiles();
        int n = 0;
        int n2 = fileArray.length;
        while (n < n2) {
            File f = fileArray[n];
            String s = FileUtil.readFirstLine(f);
            if ((s = s.trim()).startsWith("<") && s.indexOf("LineGraph") > 0) {
                ret = f;
                break;
            }
            ++n;
        }
        return ret;
    }

    public void requestClose() {
        this.exit();
    }

    public void reload() {
        E.info("time to reload...");
    }

    public void requestExit() {
        this.exit();
    }

    public void exit() {
        System.exit(0);
    }

    public void syncOptions() {
        String[] sa = new String[]{};
        if (this.dataHandler != null) {
            sa = this.dataHandler.getViewOptions();
        }
        this.viewMenu.setOptions(sa);
    }

    public void setViewStyle(String s) {
        if (this.dataHandler != null) {
            this.dataHandler.setViewStyle(s);
        }
        this.basicController.repaint();
    }

    public void attached() {
    }

    public void makeImages(File fdir) {
        for (ViewConfig vc : this.viewConfigs) {
            this.basicController.showPlot(vc.getID());
            File fout = new File(fdir, String.valueOf(vc.getID().replace(" ", "_")) + ".png");
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            BufferedImage bim = this.basicController.getSnapshot();
            try {
                ImageIO.write((RenderedImage)bim, "png", fout);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

