/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.dataview.formats;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.catacomb.dataview.formats.DataReader;
import org.catacomb.report.E;

public class MeshDataReader
implements DataReader {
    File file;
    double[][][] mesh;
    double[][][] data;
    double[] frameValues;
    String[] specieNames;
    int nvar = 0;
    DataReader coReader;

    public MeshDataReader(File f, DataReader dr) {
        this.file = f;
        this.coReader = dr;
    }

    public boolean canRead(String line) {
        boolean ret = false;
        if (line.startsWith("volumeGrid") || line.startsWith("gridConcentrations")) {
            ret = true;
        }
        return ret;
    }

    public void read() {
        ArrayList<double[][]> gcal = new ArrayList<double[][]>();
        ArrayList<Double> gridTimes = new ArrayList<Double>();
        this.specieNames = null;
        try {
            BufferedReader br = new BufferedReader(new FileReader(this.file));
            br.readLine();
            while (br.ready()) {
                int nel;
                StringTokenizer st;
                String line = br.readLine();
                if (line.trim().length() == 0) continue;
                if (line.startsWith("volumeGrid")) {
                    st = new StringTokenizer(line, " ");
                    st.nextToken();
                    nel = Integer.parseInt(st.nextToken());
                    E.info("reading the mesh " + nel);
                    this.readMesh(br, nel);
                    continue;
                }
                if (line.startsWith("gridConcentrations")) {
                    st = new StringTokenizer(line, " ");
                    st.nextToken();
                    nel = Integer.parseInt(st.nextToken());
                    int nspec = Integer.parseInt(st.nextToken());
                    double v = Double.parseDouble(st.nextToken());
                    gridTimes.add(new Double(v));
                    if (this.specieNames == null) {
                        this.specieNames = new String[nspec];
                        int i = 0;
                        while (i < nspec) {
                            this.specieNames[i] = st.nextToken();
                            ++i;
                        }
                    }
                    gcal.add(this.readGridConcs(br, nel, nspec));
                    if (this.nvar > 0) continue;
                    this.nvar = nspec;
                    continue;
                }
                if (this.coReader != null && this.coReader.canRead(line)) {
                    this.coReader.readBlock(line, br);
                    continue;
                }
                E.error("unknown content type " + line);
                break;
            }
        }
        catch (Exception ex) {
            E.error("Read error " + ex);
            ex.printStackTrace();
        }
        int ng = gcal.size();
        this.data = new double[ng][][];
        this.frameValues = new double[ng];
        int i = 0;
        while (i < ng) {
            this.frameValues[i] = (Double)gridTimes.get(i);
            this.data[i] = (double[][])gcal.get(i);
            ++i;
        }
    }

    private void readMesh(BufferedReader br, int nel) {
        this.mesh = new double[nel][][];
        try {
            int ilin = 0;
            while (ilin < nel) {
                String line = br.readLine();
                double[] dat = this.parseLine(line);
                int n = dat.length / 3;
                this.mesh[ilin] = new double[3][n];
                int i = 0;
                while (i < n) {
                    this.mesh[ilin][0][i] = dat[3 * i];
                    this.mesh[ilin][1][i] = dat[3 * i + 1];
                    this.mesh[ilin][2][i] = dat[3 * i + 2];
                    ++i;
                }
                ++ilin;
            }
        }
        catch (Exception ex) {
            E.error("ex " + ex);
        }
    }

    private double[][] readGridConcs(BufferedReader br, int nel, int nspec) {
        double[][] ret = new double[nspec][nel];
        try {
            int ilin = 0;
            while (ilin < nel) {
                String line = br.readLine();
                double[] dl = this.parseLine(line);
                int i = 0;
                while (i < nspec && i < dl.length) {
                    ret[i][ilin] = dl[i];
                    ++i;
                }
                ++ilin;
            }
        }
        catch (Exception ex) {
            E.error("ex " + ex);
        }
        return ret;
    }

    private double[] parseLine(String s) {
        StringTokenizer st = new StringTokenizer(s, " ()");
        int n = st.countTokens();
        double[] ret = new double[n];
        int i = 0;
        while (i < n) {
            ret[i] = Double.parseDouble(st.nextToken());
            ++i;
        }
        return ret;
    }

    public double[][][] getMesh() {
        return this.mesh;
    }

    public double[][][] getData() {
        return this.data;
    }

    public double[] getFrameValues() {
        return this.frameValues;
    }

    public String[] getValueNames() {
        String[] ret = this.specieNames;
        if (ret == null) {
            ret = new String[this.nvar];
            int i = 0;
            while (i < this.nvar) {
                ret[i] = "species " + i;
                ++i;
            }
        }
        return ret;
    }

    public void readBlock(String line, BufferedReader br) {
    }
}

